/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.llm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.notifications.Notification;
import com.plusmpm.util.notifications.NotificationManager;
import com.plusmpm.util.notifications.NotificationReceiver;
import com.plusmpm.util.notifications.NotificationReceiverType;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.web.dto.workflow.process.map.ProcessDto;
import com.suncode.pwfl.web.support.ajax.ResponseMessageLevel;
import com.suncode.pwfl.web.support.ajax.RestResponse;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.xpdl.share.dto.lite.XpdlDocumentLiteCreateDto;
import com.suncode.pwfl.xpdl.share.dto.lite.XpdlDocumentLiteUpdateDto;
import com.suncode.pwfl.xpdl.share.dto.share.XpdlDocumentShareCreateDto;
import com.suncode.pwfl.xpdl.share.entity.lite.XpdlDocumentLite;
import com.suncode.pwfl.xpdl.share.exception.lite.XpdlDocumentLiteException;
import com.suncode.pwfl.xpdl.share.exception.lite.XpdlDocumentLiteNotFoundException;
import com.suncode.pwfl.xpdl.share.exception.share.XpdlDocumentShareException;
import com.suncode.pwfl.xpdl.share.service.lite.XpdlDocumentLiteService;
import com.suncode.pwfl.xpdl.share.service.share.XpdlDocumentShareService;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/xpdl/document"})
public class XpdlDocumentController {
    private static final Logger log = LoggerFactory.getLogger(XpdlDocumentController.class);
    private final XpdlDocumentShareService xpdlDocumentShareService;
    private final XpdlDocumentLiteService xpdlDocumentLiteService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final MessageHelperBean messageHelperBean;

    @PostMapping(value={"share"})
    public RestResult shareXpdlDocument(@RequestBody XpdlDocumentShareCreateRequest request) {
        String userId = UserContext.current().getUser().getUserName();
        XpdlDocumentShareCreateDto createDto = new XpdlDocumentShareCreateDto(request.mapId().longValue(), userId, request.comment());
        this.xpdlDocumentShareService.createXpdlDocumentShare(createDto);
        return new RestResult(true, this.messageHelperBean.getMessage("Mapa_procesu_zostala_udostepniona"));
    }

    @PostMapping(value={"share/all/{id}"})
    public List<XpdlDocumentShareMessageDto> getSharesForXpdlDocument(@PathVariable Long id) {
        return this.xpdlDocumentShareService.getAllDocumentSharesForXpdlDocument(id).stream().map(xpdlDocumentShareDto -> new XpdlDocumentShareMessageDto(xpdlDocumentShareDto.getId(), xpdlDocumentShareDto.getUserId(), xpdlDocumentShareDto.getCommentDateUTc().toString(), xpdlDocumentShareDto.getComment(), xpdlDocumentShareDto.getState())).toList();
    }

    @PostMapping(value={"accept"})
    public RestResult acceptXpdlDocument(@RequestBody XpdlDocumentShareCreateRequest request) {
        String userId = UserContext.current().getUser().getUserName();
        XpdlDocumentShareCreateDto acceptDto = new XpdlDocumentShareCreateDto(request.mapId().longValue(), userId, request.comment());
        XpdlDocumentLite xpdlDocumentLite = (XpdlDocumentLite)this.xpdlDocumentLiteService.get((Serializable)request.mapId());
        this.xpdlDocumentShareService.acceptXpdlDocument(acceptDto);
        this.sendNotificationToUser(userId, this.messageHelperBean.getMessage("Mapa_dla_proces_zostala_zaakceptowana", new Object[]{xpdlDocumentLite.getProcessName()}));
        return new RestResult(true, this.messageHelperBean.getMessage("Mapa_procesu_zostala_zaakceptowana"));
    }

    @PostMapping(value={"reject"})
    public RestResult rejectXpdlDocument(@RequestBody XpdlDocumentShareCreateRequest request) {
        String userId = UserContext.current().getUser().getUserName();
        XpdlDocumentShareCreateDto rejectDto = new XpdlDocumentShareCreateDto(request.mapId().longValue(), userId, request.comment());
        this.xpdlDocumentShareService.rejectXpdlDocument(rejectDto);
        XpdlDocumentLite xpdlDocumentLite = (XpdlDocumentLite)this.xpdlDocumentLiteService.get((Serializable)request.mapId());
        this.sendNotificationToUser(userId, this.messageHelperBean.getMessage("Mapa_dla_proces_zostala_odrzucona", new Object[]{xpdlDocumentLite.getProcessName()}));
        return new RestResult(true, this.messageHelperBean.getMessage("Mapa_procesu_zostala_odrzucona"));
    }

    private void sendNotificationToUser(String userId, String message) {
        Notification notification = new Notification();
        notification.setFailure(Boolean.valueOf(false));
        notification.setMessage(message);
        notification.setSender("System");
        NotificationReceiver receiver = new NotificationReceiver(NotificationReceiverType.USER, userId);
        NotificationManager.add((Notification)notification, (NotificationReceiver)receiver);
    }

    @PutMapping(value={"xpdl"})
    public RestResponse<Long> saveXpdlDocument(@RequestBody ProcessDto processDto) throws JsonProcessingException {
        String userId = UserContext.current().getUser().getUserName();
        XpdlDocumentLiteCreateDto createDto = new XpdlDocumentLiteCreateDto(userId, this.objectMapper.writeValueAsString((Object)processDto), processDto.getName());
        Long xpdlDocumentLiteId = this.xpdlDocumentLiteService.createXpdlDocumentLite(createDto);
        return new RestResponse(this.messageHelperBean.getMessage("Mapa_procesu_zostala_zapisana"), ResponseMessageLevel.SUCCESS, (Object)xpdlDocumentLiteId);
    }

    @PatchMapping(value={"xpdl/{id}"})
    public RestResult updateXpdlDocument(@PathVariable Long id, @RequestBody ProcessDto processDto) throws JsonProcessingException {
        XpdlDocumentLiteUpdateDto updateDto = new XpdlDocumentLiteUpdateDto(this.objectMapper.writeValueAsString((Object)processDto), processDto.getName());
        this.xpdlDocumentLiteService.updateXpdlDocumentLite(id, updateDto);
        return new RestResult(true, this.messageHelperBean.getMessage("Mapa_procesu_zostala_zapisana"));
    }

    @DeleteMapping(value={"xpdl/{id}"})
    public RestResult deleteXpdlDocument(@PathVariable Long id) {
        this.xpdlDocumentLiteService.deleteXpdlDocumentLite(id);
        return new RestResult(true, this.messageHelperBean.getMessage("Mapa_procesu_zostala_usunieta"));
    }

    @GetMapping(value={"all/forUser"})
    public CountedResult<XpdlDocumentLiteForUser> getXpdlDocumentsForUser(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="modifiedDate") String orderBy, @RequestParam(required=false, defaultValue="DESC") SortDirection orderDirection) {
        String userId = UserContext.current().getUser().getUserName();
        CountedResult xpdlDocumentsLiteForUser = this.xpdlDocumentLiteService.getXpdlDocumentsLiteForUser(start, limit, orderBy, orderDirection, userId);
        return new CountedResult(xpdlDocumentsLiteForUser.getTotal(), xpdlDocumentsLiteForUser.getData().stream().map(xpdl -> new XpdlDocumentLiteForUser(xpdl.getId(), xpdl.getCreatedDate().toString(), xpdl.getModifiedDate().toString(), xpdl.getProcessName(), xpdl.getState())).toList());
    }

    @GetMapping(value={"processMap/{id}/content"})
    public ProcessDto getProcessMapContent(@PathVariable Long id) throws JsonProcessingException {
        return (ProcessDto)this.objectMapper.readValue(new String(this.xpdlDocumentLiteService.getXpdlDocumentLite(id).getProcessMapJson()), ProcessDto.class);
    }

    @ExceptionHandler(value={XpdlDocumentLiteNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public RestResult handleXpdlDocumentLiteNotFound(XpdlDocumentLiteNotFoundException e) {
        return new RestResult(false, this.messageHelperBean.getMessage("Nie_znaleziono_dokumentu_XPDL_o_podanym_id", new Object[]{e.getId()}));
    }

    @ExceptionHandler(value={XpdlDocumentShareException.class, JsonProcessingException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult handleXpdlDocumentShareException(Exception e) {
        return new RestResult(false, this.messageHelperBean.getMessage("Blad_zwiazany_z_udostepnianiem_dokumentu_xpdl"));
    }

    @ExceptionHandler(value={XpdlDocumentLiteException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult handleXpdlDocumentLiteException(Exception e) {
        return new RestResult(false, this.messageHelperBean.getMessage("Blad_zwiazany_z_dokumentem_xpdl"));
    }

    @ConstructorProperties(value={"xpdlDocumentShareService", "xpdlDocumentLiteService", "messageHelperBean"})
    @Autowired
    public XpdlDocumentController(XpdlDocumentShareService xpdlDocumentShareService, XpdlDocumentLiteService xpdlDocumentLiteService, MessageHelperBean messageHelperBean) {
        this.xpdlDocumentShareService = xpdlDocumentShareService;
        this.xpdlDocumentLiteService = xpdlDocumentLiteService;
        this.messageHelperBean = messageHelperBean;
    }

    public record XpdlDocumentShareCreateRequest(Long mapId, String comment) {
    }

    public record XpdlDocumentLiteForUser(Long id, String createdDate, String modifiedDate, String processName, String state) {
    }

    public record XpdlDocumentShareMessageDto(Long id, String userId, String commentDate, String comment, String state) {
    }
}

