/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.documents.links;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocsMerger.DocsMerger;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.IndexData;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.archive.documentclass.model.DocumentSearchVariableSearchModel;
import com.suncode.pwfl.archive.links.mapper.DocumentLinkSearchModelMapper;
import com.suncode.pwfl.archive.links.model.DocumentLinkDocumentClassSearchModel;
import com.suncode.pwfl.archive.links.model.DocumentLinkSearchModel;
import com.suncode.pwfl.archive.links.service.DocumentLinksSearchService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowTempFileCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.TempFileCacheConfig;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"documents/links/search"})
@Api(hidden=true)
public class DocumentLinksSearchController {
    private static final Logger log = LoggerFactory.getLogger(DocumentLinksSearchController.class);
    private final DocumentLinksSearchService documentLinksSearchService;
    private final AuthorizationHelper authorizationHelper;
    private final DocumentClassService documentClassService;
    private final DocumentLinkSearchModelMapper documentLinkSearchModelMapper;
    private final String rightLevelPattern = RightTreeBuilder.builder().system().archive().links().custom((Object)"%d").build();
    private final Map<UUID, List<ExportColumn>> exportColumnsCache = new HashMap<UUID, List<ExportColumn>>();
    private final ExportService exportService;
    private final LinkService linkService;
    private final MessageHelperBean messageHelper;
    private final CacheFactory cacheFactory;
    private PlusWorkflowTempFileCache exportCache;

    @PostConstruct
    private void init() {
        this.exportCache = this.cacheFactory.createTempFileCache(SystemCacheId.DOCUMENT_LINKS_SEARCH_EXPORT_CACHE, TempFileCacheConfig.builder().build());
    }

    @PostMapping(value={"{linkId}/results"})
    public CountedResult<DocumentData> searchDocumentsFromLink(HttpServletRequest request, @PathVariable Long linkId, @RequestBody DocumentLinkSearchModel documentLinkSearchModel, @RequestParam(name="start", required=false) Long start, @RequestParam(name="limit", required=false) Long limit, @RequestParam(name="orderBy", required=false, defaultValue="0") Long orderBy, @RequestParam(name="orderDirection", required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullOrPartRights(String.format(this.rightLevelPattern, linkId), () -> {});
        String searchedDocumentClasses = documentLinkSearchModel.documentClasses().stream().map(documentClass -> documentClass.id().toString()).collect(Collectors.joining(","));
        DocumentSearchVariableSearchModel addToArchiveDate = documentLinkSearchModel.addToArchiveDate();
        String dateFinish = addToArchiveDate.value().getTo();
        String dateStart = addToArchiveDate.value().getFrom();
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("lines[0].varValue", linkId);
        auditParams.put("searchedDocumentClasses", searchedDocumentClasses);
        auditParams.put("dateStart", dateStart);
        auditParams.put("dateFinish", dateFinish);
        auditParams.putAll(this.documentLinkSearchModelMapper.getFiltersMap(documentLinkSearchModel.linkFilters()));
        auditParams.entrySet().removeIf(entry -> entry.getValue() == null || entry.getValue() instanceof String && ((String)entry.getValue()).isEmpty());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_LINK).params(auditParams);
        try {
            CountedResult result = this.documentLinksSearchService.search(linkId, documentLinkSearchModel, start, limit, Long.valueOf(orderBy.intValue() == 0 ? 0 : orderBy.intValue() + 1), Long.valueOf("DESC".equals(orderDirection.name()) ? 1L : 2L));
            auditBuilder.buildSuccess(request);
            return result;
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @PostMapping(value={"{linkId}/results/rights/print"})
    public RestResult canPrintSearchedDocuments(@PathVariable Long linkId, @RequestBody List<Long> documentClasses) throws SQLException {
        this.authorizationHelper.assertFullOrPartRights(String.format(this.rightLevelPattern, linkId), () -> {});
        Map<Long, Long> rightMap = this.getRightMap(documentClasses);
        if (rightMap.containsValue(0L)) {
            ArrayList<String> documentClassesWithNoRights = new ArrayList<String>();
            for (Long id : rightMap.entrySet().stream().filter(entry -> ((Long)entry.getValue()).equals(-1L)).map(Map.Entry::getKey).toList()) {
                documentClassesWithNoRights.add(this.documentClassService.getDocumentClassTranslation(id, TranslatedFieldType.NAME));
            }
            return new RestResult(true, String.join((CharSequence)", ", documentClassesWithNoRights));
        }
        return new RestResult(false);
    }

    private Map<Long, Long> getRightMap(List<Long> documentClasses) throws SQLException {
        String username = UserContext.current().getUser().getUserName();
        HashMap<Long, Long> rightMap = new HashMap<Long, Long>();
        for (Long id : documentClasses) {
            long printRights = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)id).printing().build(), (String)username, (boolean)false, (boolean)false);
            rightMap.put(id, printRights);
        }
        return rightMap;
    }

    @PostMapping(value={"{linkId}/results/print"})
    public URI printSearchedDocumentsFromLink(HttpServletRequest request, @PathVariable Long linkId, @RequestBody DocumentLinkSearchModel documentLinkSearchModel, @RequestParam(name="orderBy", required=false, defaultValue="0") Long orderBy, @RequestParam(name="orderDirection", required=false, defaultValue="ASC") SortDirection orderDirection) throws SQLException {
        this.authorizationHelper.assertFullOrPartRights(String.format(this.rightLevelPattern, linkId), () -> {});
        Map<Long, Long> rightMap = this.getRightMap(documentLinkSearchModel.documentClasses().stream().map(DocumentLinkDocumentClassSearchModel::id).toList());
        List<DocumentData> documentData = this.documentLinksSearchService.search(linkId, documentLinkSearchModel, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(orderBy.intValue() == 0 ? 0 : orderBy.intValue() + 1), Long.valueOf("DESC".equals(orderDirection.name()) ? 1L : 2L)).getData().stream().filter(document -> {
            Long right = (Long)rightMap.get(document.getLDocClassId());
            return right.equals(0L) || right.equals(1L);
        }).toList();
        LinkedList<Long> filesToConvert = new LinkedList<Long>();
        for (DocumentData document2 : documentData) {
            filesToConvert.add(document2.getLFileId());
        }
        UUID id = this.exportCache.putDto(filesToConvert);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    @GetMapping(value={"{linkId}/results/print"})
    public void printSearchedDocumentsFromLink(HttpServletResponse response, @RequestParam UUID id, @PathVariable Long linkId) throws IOException {
        this.authorizationHelper.assertFullOrPartRights(String.format(this.rightLevelPattern, linkId), () -> {});
        List filesToConvert = (List)this.exportCache.getDtoList(id, Long.class).orElseThrow();
        this.exportCache.invalidate(id);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"Documents.pdf\"");
        try {
            DocsMerger.merge((List)filesToConvert, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.info("Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia dokument\u00f3w");
        }
    }

    @PostMapping(value={"{linkId}/results/export/{extension}"})
    public URI exportDocumentsFromLink(HttpServletRequest request, @PathVariable Long linkId, @RequestBody DocumentLinkSearchModel documentLinkSearchModel, @PathVariable String extension, @RequestParam(name="orderBy", required=false, defaultValue="0") Long orderBy, @RequestParam(name="orderDirection", required=false, defaultValue="ASC") SortDirection orderDirection) {
        List documentData = this.documentLinksSearchService.search(linkId, documentLinkSearchModel, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), Long.valueOf(orderBy.intValue() == 0 ? 0 : orderBy.intValue() + 1), Long.valueOf("DESC".equals(orderDirection.name()) ? 1L : 2L)).getData();
        Queue columnOrder = documentLinkSearchModel.linkFilters().stream().map(DocumentSearchVariableSearchModel::id).collect(Collectors.toCollection(LinkedList::new));
        boolean showDate = documentLinkSearchModel.addToArchiveDate().value().getExtraValueSearchModel().isShowColumn();
        List<Map<Long, String>> indexData = this.getIndexData(documentData);
        List<ExportColumn> columns = this.prepareColumns(documentData, indexData, columnOrder, showDate);
        return this.getRedirectUri(request, columns);
    }

    @GetMapping(value={"{linkId}/results/export/{extension}"})
    public void exportDocumentsFromLink(HttpServletResponse response, @PathVariable Long linkId, @PathVariable String extension, @RequestParam UUID id) throws IOException {
        this.exportDocuments(this.getCachedColumns(id), response, extension);
    }

    private List<Map<Long, String>> getIndexData(List<DocumentData> documentData) {
        if (documentData.isEmpty()) {
            throw new ServiceException(this.messageHelper.getMessage("Brak_dokumentow_do_eksportu"));
        }
        return documentData.stream().map(list -> list.getAlIndecies().stream().collect(Collectors.toMap(IndexData::getId, IndexData::getValue))).toList();
    }

    private List<ExportColumn> prepareColumns(List<DocumentData> documentData, List<Map<Long, String>> indexData, Queue<String> columnOrder, boolean showDate) {
        LinkedList<ExportColumn> columns = new LinkedList<ExportColumn>();
        columns.add(this.buildExportColumn(this.messageHelper.getMessage("Klasa_dokumentow"), documentData, DocumentData::getDocClassViewName));
        if (!indexData.isEmpty()) {
            Map<Long, String> firstRow = indexData.get(0);
            while (!columnOrder.isEmpty()) {
                String indexId = columnOrder.poll();
                if (!firstRow.containsKey(Long.parseLong(indexId))) continue;
                columns.add(this.buildExportColumn(this.linkService.getLinkIndexTranslation(Long.valueOf(Long.parseLong(indexId)), TranslatedFieldType.NAME), indexData, indices -> (String)indices.get(Long.parseLong(indexId))));
            }
        }
        if (showDate) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Data_dokumentu"), documentData, DocumentData::getSDocumentDate));
        }
        return columns;
    }

    private URI getRedirectUri(HttpServletRequest request, List<ExportColumn> columns) {
        UUID id;
        while (this.exportColumnsCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportColumnsCache.put(id, columns);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private List<ExportColumn> getCachedColumns(UUID id) {
        List<ExportColumn> columns = this.exportColumnsCache.get(id);
        this.exportColumnsCache.remove(id);
        return columns;
    }

    private void exportDocuments(List<ExportColumn> columns, HttpServletResponse response, String extension) throws IOException {
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Dokumenty")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private <T> ExportColumn buildExportColumn(String name, List<T> data, Function<T, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @ConstructorProperties(value={"documentLinksSearchService", "authorizationHelper", "documentClassService", "documentLinkSearchModelMapper", "exportService", "linkService", "messageHelper", "cacheFactory"})
    @Autowired
    public DocumentLinksSearchController(DocumentLinksSearchService documentLinksSearchService, AuthorizationHelper authorizationHelper, DocumentClassService documentClassService, DocumentLinkSearchModelMapper documentLinkSearchModelMapper, ExportService exportService, LinkService linkService, MessageHelperBean messageHelper, CacheFactory cacheFactory) {
        this.documentLinksSearchService = documentLinksSearchService;
        this.authorizationHelper = authorizationHelper;
        this.documentClassService = documentClassService;
        this.documentLinkSearchModelMapper = documentLinkSearchModelMapper;
        this.exportService = exportService;
        this.linkService = linkService;
        this.messageHelper = messageHelper;
        this.cacheFactory = cacheFactory;
    }
}

