/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates.fetchers;

import com.suncode.pwfl.certificates.exceptions.CertificateScanException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherBase;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherSimple;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class CertificateFetcherLDAP
extends CertificateFetcherBase {
    public CertificateFetcherLDAP(String host, int port) {
        super(host, port);
    }

    @Override
    public Certificate[] tryFetch(int timeout) {
        try {
            CertificateFetcherSimple fetcher = new CertificateFetcherSimple(this.host, this.port);
            return fetcher.tryFetch(timeout);
        }
        catch (ServiceException fetcher) {
            Context ctx = null;
            StartTlsResponse tls = null;
            try {
                SSLSocketFactory ssf = this.getInsecureSocketFactory();
                Hashtable<String, Object> env = new Hashtable<String, Object>(11);
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + this.host + ":" + this.port);
                env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(timeout));
                env.put("com.sun.jndi.ldap.read.timeout", String.valueOf(timeout));
                ctx = new InitialLdapContext(env, null);
                tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                tls.setHostnameVerifier((hostname, sslSession) -> true);
                SSLSession session = tls.negotiate(ssf);
                Certificate[] certificateArray = session.getPeerCertificates();
                return certificateArray;
            }
            catch (KeyManagementException e) {
                throw new CertificateScanException("Could not create SSL socket", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertificateScanException("Unknown secure algorithm", (Throwable)e);
            }
            catch (IOException e) {
                throw new CertificateScanException("Error occurred during estabilishing connection", (Throwable)e);
            }
            catch (NamingException e) {
                throw new CertificateScanException("Target host is unreachable", (Throwable)e);
            }
            finally {
                try {
                    if (tls != null) {
                        tls.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException namingException) {}
            }
        }
    }
}

