/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.database.documentViews.dto.AddDocumentViewsTableDto;
import com.plusmpm.database.documentViews.dto.ReadDocumentViewsTableDto;
import com.plusmpm.database.documentViews.exception.DocumentViewNotFoundException;
import com.plusmpm.i18n.AbstractI18N;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemPropertiesBean;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserConfigureFormValidator;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.administration.user.UserViewConfForm;
import com.suncode.pwfl.administration.user.UserViewDataDto;
import com.suncode.pwfl.archive.DocumentViewsService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.util.menuitem.MenuTabCache;
import com.suncode.pwfl.web.controller.api.administration.processes.documentViews.DocumentViewsAuditHelper;
import com.suncode.pwfl.web.controller.api.administration.user.UserSettingsHelper;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.DocumentViewsMapper;
import com.suncode.pwfl.web.support.UserLocaleResolver;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.ui.skin.Skin;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user/settings"})
@Api(tags={"appearance"})
public class UserSettingsController {
    private static final Logger log = LoggerFactory.getLogger(UserSettingsController.class);
    @Autowired
    private UserLocaleResolver userLocaleResolver;
    @Autowired
    private DocumentViewsService documentViewsService;
    @Autowired
    private DocumentViewsMapper documentViewsMapper;
    @Autowired
    private DocumentViewsAuditHelper auditHelper;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private UserConfigureFormValidator userConfigureFormValidator;
    @Autowired
    private UserSettingsHelper userSettingsHelper;
    @Autowired
    private SystemPropertiesBean systemProperties;
    private final Map<UserSettingsService.UserSetting, Function<UserViewConfForm, String>> settingsSupplierMap = new ImmutableMap.Builder().put((Object)UserSettingsService.UserSetting.LANGUAGE, UserViewConfForm::getLanguage).put((Object)UserSettingsService.UserSetting.PAGE_SIZE, UserViewConfForm::getPageSize).put((Object)UserSettingsService.UserSetting.NOTIFICATIONS, UserViewConfForm::getNotifs).put((Object)UserSettingsService.UserSetting.BLOCK_CHANGE_SHOW_NOTIFICATIONS, UserViewConfForm::getBlockChangeNotifs).put((Object)UserSettingsService.UserSetting.EMAILS, UserViewConfForm::getEmails).put((Object)UserSettingsService.UserSetting.VIEW_AVATAR, UserViewConfForm::getViewAvatar).put((Object)UserSettingsService.UserSetting.TASK_AVATAR, UserViewConfForm::getTaskAvatar).put((Object)UserSettingsService.UserSetting.TEMPLATE, UserViewConfForm::getTemplate).put((Object)UserSettingsService.UserSetting.COMPACT_TEMPLATE, UserViewConfForm::getCompactTemplate).build();

    @GetMapping(value={"locale"})
    @ResponseBody
    @ApiOperation(value="Downloading user's language", notes="Retrieves a logged-in user's language")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Map<String, String> getLocale(HttpServletRequest request) {
        Locale locale = this.userLocaleResolver.resolveLocale((jakarta.servlet.http.HttpServletRequest)request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("languageCode", locale.getLanguage());
        map.put("countryCode", locale.getCountry());
        return map;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"appearance/{name}"})
    public String getUserSettingValueBySettingName(@PathVariable String name) {
        if (!this.settingsSupplierMap.keySet().toString().contains(name)) {
            throw new ServiceException(this.messageHelper.getMessage("Ustawienie_o_podanej_nazwie_nie_istnieje"));
        }
        String username = UserContext.current().getUser().getUserName();
        String setting = this.userSettingsService.getSetting(username, name);
        return setting == null ? "on" : setting;
    }

    @GetMapping(value={"appearance"})
    @ResponseBody
    @ApiOperation(value="Downloading a map of user settings", notes="Retrieves a map of logged-in user settings")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public UserSettingsDto getUserAppearanceSettings() {
        UserSettingsDto userSettings = new UserSettingsDto();
        Map settings = this.userSettingsService.getSettings(UserContext.current().getUser().getUserName());
        AtomicReference<String> defaultView = new AtomicReference<String>((String)settings.get(UserSettingsService.UserSetting.DEFAULT_VIEW.getName()));
        String defaultViewName = this.userSettingsHelper.getDefaultViewName(defaultView);
        List defaultUserViews = this.userSettingsService.getDefaultUserViews(UserContext.current().getUser().getUserName());
        boolean isViewAvailableForUser = defaultUserViews.stream().anyMatch(userViewDataDto -> userViewDataDto.id().equals(defaultView.get()));
        userSettings.setEmails((String)settings.get(UserSettingsService.UserSetting.EMAILS.toString()));
        userSettings.setTemplate((String)settings.get(UserSettingsService.UserSetting.TEMPLATE.toString()));
        userSettings.setCompactTemplate((String)settings.get(UserSettingsService.UserSetting.COMPACT_TEMPLATE.toString()));
        userSettings.setDefaultView((String)settings.get(UserSettingsService.UserSetting.DEFAULT_VIEW.toString()));
        userSettings.setNotifs((String)settings.get(UserSettingsService.UserSetting.NOTIFICATIONS.toString()));
        userSettings.setBlockChangeNotifs((String)settings.get(UserSettingsService.UserSetting.BLOCK_CHANGE_SHOW_NOTIFICATIONS.toString()));
        userSettings.setLaguage((String)settings.get(UserSettingsService.UserSetting.LANGUAGE.toString()));
        userSettings.setPageSize((String)settings.get(UserSettingsService.UserSetting.PAGE_SIZE.toString()));
        userSettings.setTaskAvatar((String)settings.get(UserSettingsService.UserSetting.TASK_AVATAR.toString()));
        userSettings.setViewAvatar((String)settings.get(UserSettingsService.UserSetting.VIEW_AVATAR.toString()));
        if (!isViewAvailableForUser && StringUtils.isNotBlank((String)defaultView.get())) {
            userSettings.setDefaultViewName(defaultViewName + " (" + this.messageHelper.getMessage("Niedostepne") + ")");
            userSettings.setViewAvailable(false);
            return userSettings;
        }
        userSettings.setViewAvailable(true);
        userSettings.setDefaultViewName(defaultViewName);
        return userSettings;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"skin"})
    public SkinDto getSkin() {
        Skin skin = this.userSettingsService.getSkinForUser(UserContext.current().getUser().getUserName());
        return new SkinDto(skin.getKey().replace("-", "_"));
    }

    @PostMapping(value={"appearance"})
    @ResponseBody
    @ApiOperation(value="Saves user settings", notes="Saves logged-in user settings. The executed query changes the settings of logged-in user. The query is a JSON object with the following fields: \n- **language** - language of the system (en, pl...) \n- **template** - theme (pwfl-blue, pwfl-dark, pwfl-high-contrast) \n- **compactTemplate** - interface appearance (default, compact) \n- **pageSize** - number of items per page (10, 20, 30, 50) \n- **defaultView** - default view \n- **notifs** - show (on, off) \n- **emails** - receive email notifications (on, off) \n- **viewAvatar** - avatar display in views (avatarOnly, avatarWithFirstAndLastName) \n- **taskAvatar** - avatar display in task box (avatarOnly, avatarWithFirstAndLastName)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult saveUserAppearanceSettings(@RequestBody UserViewConfForm userViewConfForm, HttpServletRequest request, HttpSession session) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER_SETTINGS);
        userViewConfForm.setGlobalChange(false);
        Map<String, Object> auditParams = this.createAuditParameters(userViewConfForm);
        auditBuilder.params(auditParams);
        this.userConfigureFormValidator.validateUserViewConfigureForm(userViewConfForm, false);
        User user = this.userFinder.findByUserName(UserContext.current().getUser().getUserName(), new String[0]);
        Map<String, String> settings = this.prepareSettingsToUpdate(userViewConfForm);
        if (StringUtils.isNotBlank((String)userViewConfForm.getDefaultView())) {
            settings.put(UserSettingsService.UserSetting.DEFAULT_VIEW.getName(), userViewConfForm.getDefaultView());
        }
        try {
            this.updateUserSettings(userViewConfForm, session, user, settings);
        }
        catch (DataIntegrityViolationException e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Nie_udalo_sie_zmienic_ustawien"), (Throwable)e);
        }
        catch (ServiceException e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    private void updateUserSettings(UserViewConfForm userViewConfForm, HttpSession session, User user, Map<String, String> settings) {
        this.userSettingsService.setUserSetting(user, settings);
        MenuTabCache.clear((String)user.getUserName());
        this.setSessionLocale(user.getUserName(), userViewConfForm, session);
    }

    private List<User> getUsersToChange(String resourceName, Boolean isGroup) {
        if (StringUtils.isBlank((String)resourceName)) {
            return this.userFinder.getAll(new String[0]);
        }
        return isGroup != false ? new ArrayList(this.userService.getGroup(resourceName, new String[]{"users"}).getUsers()) : Collections.singletonList(this.userService.getUser(resourceName, new String[0]));
    }

    @PostMapping(value={"appearance/globally"})
    @ResponseBody
    @ApiOperation(value="(Admin) Saves user settings for user/group", notes="Saves user settings for user/group. The executed query changes the settings of logged-in user. The query is a JSON object with the following fields: \n- **resourceName** - name of the resource \n- **isGroup** - is resource a group \n- **language** - language of the system (en, pl...) \n- **template** - theme (pwfl-blue, pwfl-dark, pwfl-high-contrast) \n- **compactTemplate** - interface appearance (default, compact) \n- **pageSize** - number of items per page (10, 20, 30, 50) \n- **defaultView** - default view \n- **notifs** - show (on, off) \n- **emails** - receive email notifications (on, off) \n- **viewAvatar** - avatar display in views (avatarOnly, avatarWithFirstAndLastName) \n- **taskAvatar** - avatar display in task box (avatarOnly, avatarWithFirstAndLastName)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult saveUserAppearanceSettingsGlobally(@RequestBody UserViewConfForm userViewConfForm, HttpServletRequest request, HttpSession session) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_USER_SETTINGS_GLOBAL);
        userViewConfForm.setGlobalChange(true);
        Map<String, Object> auditParams = this.createAuditParameters(userViewConfForm);
        auditBuilder.params(auditParams);
        this.userConfigureFormValidator.validateUserViewConfigureForm(userViewConfForm, true);
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().admin().build(), () -> auditBuilder.buildFailure(request));
        Map<String, String> settings = this.prepareSettingsToUpdate(userViewConfForm);
        if (StringUtils.isNotBlank((String)userViewConfForm.getDefaultView())) {
            settings.put(UserSettingsService.UserSetting.DEFAULT_VIEW.getName(), userViewConfForm.getDefaultView());
        }
        List<User> usersToChange = this.getUsersToChange(userViewConfForm.getResourceName(), Boolean.valueOf(userViewConfForm.getIsGroup()));
        auditParams.put("usernames", usersToChange.stream().map(User::getUserName).collect(Collectors.joining(", ")));
        auditBuilder.params(auditParams);
        try {
            List userChunks = Lists.partition(usersToChange, (int)500);
            AtomicInteger count = new AtomicInteger();
            IntStream.range(0, userChunks.size()).parallel().forEach(chunkIndex -> {
                List chunk = (List)userChunks.get(chunkIndex);
                for (User user : chunk) {
                    this.updateUserSettings(userViewConfForm, session, user, settings);
                    if (count.incrementAndGet() % 500 != 0) continue;
                    log.info("Updated {} users so far", (Object)count);
                }
            });
        }
        catch (DataIntegrityViolationException e) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Nie_udalo_sie_zmienic_ustawien"), (Throwable)e);
        }
        catch (ServiceException e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    private Map<String, Object> createAuditParameters(final UserViewConfForm userViewConfForm) {
        return new LinkedHashMap<String, Object>(){
            {
                this.put("language", StringUtils.defaultString((String)userViewConfForm.getLanguage()));
                this.put("pageSize", StringUtils.defaultString((String)userViewConfForm.getPageSize()));
                this.put("defaultView", StringUtils.defaultString((String)userViewConfForm.getDefaultViewName()));
                this.put("notifs", StringUtils.defaultString((String)userViewConfForm.getNotifs()));
                this.put("blockChangeNotifs", StringUtils.defaultString((String)userViewConfForm.getBlockChangeNotifs()));
                this.put("emails", StringUtils.defaultString((String)userViewConfForm.getEmails()));
                this.put("taskAvatar", StringUtils.defaultString((String)userViewConfForm.getTaskAvatar()));
                this.put("viewAvatar", StringUtils.defaultString((String)userViewConfForm.getViewAvatar()));
                this.put("template", StringUtils.defaultString((String)userViewConfForm.getTemplate()));
                this.put("compactTemplate", StringUtils.defaultString((String)userViewConfForm.getCompactTemplate()));
            }
        };
    }

    @GetMapping(value={"default-views"})
    @ResponseBody
    @ApiOperation(value="Downloading available default views", notes="Retrieves a list of views available to logged-in user")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public List<UserViewDataDto> getUserDefaultViews() {
        return this.userSettingsService.getDefaultUserViews(UserContext.current().getUser().getUserName()).stream().map(defaultView -> new UserViewDataDto(defaultView.id(), defaultView.name(), defaultView.level(), defaultView.url())).toList();
    }

    @GetMapping(value={"document/views"})
    @ResponseBody
    @ApiOperation(value="Downloading a list of user document views", notes="Retrieves a list of user document views")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public CountedResult<ReadDocumentViewsTableDto> getDocumentViewsByLoggedUsername(@ApiParam(value="Result number from which results are to be returned", defaultValue="0") @RequestParam(required=false, defaultValue="0") Integer start, @ApiParam(value="Number of returned results", defaultValue="20") @RequestParam(required=false, defaultValue="20") Integer limit, @ApiParam(value="Sort by", defaultValue="documentViewName") @RequestParam(required=false, defaultValue="documentViewName") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        List documentViews = this.documentViewsService.getDocumentViewsByUsername(UserContext.current().getUser().getUserName()).stream().map(this.documentViewsMapper::toDto).sorted((Comparator<ReadDocumentViewsTableDto>)DtoComparator.of(ReadDocumentViewsTableDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        return Paginator.forAll(documentViews).viewPageByOffset(start, limit);
    }

    @DeleteMapping(value={"document/views/{id}"})
    @ResponseBody
    @ApiOperation(value="Deleting user document view", notes="Deletes document view with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult deleteDocumentView(HttpServletRequest request, @ApiParam(value="Document view id", required=true) @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW);
        DocumentViewsTable view = (DocumentViewsTable)this.documentViewsService.get((Serializable)id);
        if (view == null) {
            throw new DocumentViewNotFoundException(this.messageHelper.getMessage("Widok_o_podanym_id_nie_istnieje"));
        }
        auditBuilder.params(this.auditHelper.createDeleteDocumentViewAuditParams(id, view.getProc_def_id()));
        String username = UserContext.current().getUser().getUserName();
        if (!view.getUser_id().equals(username) && !Authorization.checkIsUserAdmin((String)username)) {
            throw new NoRightsException();
        }
        try {
            this.documentViewsService.deleteDocumentViewById(id);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @PostMapping(value={"document/views"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    @ApiOperation(value="Saves user document view", notes="Saves document view for logged-in user. The executed query saves document view for logged-in user. The query is a JSON object with the following fields: \n- **documentViewName** - view name (required) \n- **documentViewDesc** - view description \n- **procDefId** - process definition id of the process \n- **taskDefId** - task definition id (requires process definition id) \n- **docClassId** - document class id \n- **descending** - show documents in descending order \n- **amount** - amount of documents (required) \n- **regex** - regex \n- **showOn** - display on form, history, all (SHOW_FORM, SHOW_HISTORY, SHOW_ALL)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult addDocumentView(HttpServletRequest request, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOCUMENT_VIEW);
        addDocumentViewsTableDto.setUserId(UserContext.current().getUser().getUserName());
        Map<String, Object> addDocumentViewAuditParams = this.auditHelper.createAddDocumentViewAuditParams(addDocumentViewsTableDto);
        auditBuilder.params(addDocumentViewAuditParams);
        try {
            DocumentViewsTable viewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            long documentViewId = this.documentViewsService.addDocumentView(viewsTable);
            addDocumentViewAuditParams.put("documentViewId", StringUtils.defaultString((String)String.valueOf(documentViewId)));
            auditBuilder.params(addDocumentViewAuditParams);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @PatchMapping(value={"document/views/{id}"})
    @ResponseBody
    @ApiOperation(value="Updates user document view", notes="Updates document view with specified id for logged-in user. The executed query saves document view for logged-in user. The query is a JSON object with the following fields: \n- **documentViewName** - view name (required) \n- **documentViewDesc** - view description \n- **procDefId** - process definition id of the process \n- **taskDefId** - task definition id (requires process definition id) \n- **docClassId** - document class id \n- **descending** - show documents in descending order \n- **amount** - amount of documents (required) \n- **regex** - regex \n- **showOn** - display on form, history, all (SHOW_FORM, SHOW_HISTORY, SHOW_ALL)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public RestResult changeDocumentView(HttpServletRequest request, @RequestBody AddDocumentViewsTableDto addDocumentViewsTableDto, @ApiParam(value="View id", required=true) @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOCUMENT_VIEW);
        DocumentViewsTable documentView = (DocumentViewsTable)this.documentViewsService.get((Serializable)id);
        if (Objects.isNull(documentView)) {
            throw new DocumentViewNotFoundException(this.messageHelper.getMessage("Widok_o_podanym_id_nie_istnieje"));
        }
        String username = UserContext.current().getUser().getUserName();
        if (!documentView.getUser_id().equals(username) && !Authorization.checkIsUserAdmin((String)username)) {
            throw new NoRightsException();
        }
        addDocumentViewsTableDto.setUserId(UserContext.current().getUser().getUserName());
        auditBuilder.params(this.auditHelper.createEditDocumentViewAuditParams(addDocumentViewsTableDto, documentView));
        try {
            DocumentViewsTable documentViewsTable = this.documentViewsMapper.toEntity(addDocumentViewsTableDto);
            documentViewsTable.setId(id);
            this.documentViewsService.changeDocumentView(documentViewsTable);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @ResponseBody
    @RequestMapping(value={"parameter/blockChangeShowNotificationsSetting"})
    public Boolean getBlockChangeShowNotificationsSetting() {
        return this.systemProperties.getBoolean(DefinedSystemParameter.BLOCK_CHANGE_SHOW_NOTIFICATIONS_SETTING);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleIllegalArgumentException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={DocumentViewNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(DocumentViewNotFoundException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoRightsException(NoRightsException e) {
        log.info(e.getMessage());
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_widoku_dokumentu"));
    }

    private Map<String, String> prepareSettingsToUpdate(UserViewConfForm userViewConfForm) {
        HashMap<String, String> settings = new HashMap<String, String>();
        this.settingsSupplierMap.forEach((setting, supplierFunction) -> {
            String settingValue = (String)supplierFunction.apply(userViewConfForm);
            if (settingValue != null) {
                settings.put(setting.getName(), settingValue);
            }
        });
        return settings;
    }

    private void setSessionLocale(String userName, UserViewConfForm userViewConfForm, HttpSession session) {
        String language = userViewConfForm.getLanguage();
        if (StringUtils.isNotBlank((String)language) && session.getAttribute("username").equals(userName)) {
            AbstractI18N.setSessionLocale((jakarta.servlet.http.HttpSession)((jakarta.servlet.http.HttpSession)session), (String)language);
        }
    }

    public static class UserSettingsDto {
        private String emails;
        private String template;
        private String compactTemplate;
        private String defaultView;
        private String notifs;
        private String blockChangeNotifs;
        private String laguage;
        private String pageSize;
        private String defaultViewName;
        private boolean isViewAvailable;
        private String taskAvatar;
        private String viewAvatar;

        public String getEmails() {
            return this.emails;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getCompactTemplate() {
            return this.compactTemplate;
        }

        public String getDefaultView() {
            return this.defaultView;
        }

        public String getNotifs() {
            return this.notifs;
        }

        public String getBlockChangeNotifs() {
            return this.blockChangeNotifs;
        }

        public String getLaguage() {
            return this.laguage;
        }

        public String getPageSize() {
            return this.pageSize;
        }

        public String getDefaultViewName() {
            return this.defaultViewName;
        }

        public boolean isViewAvailable() {
            return this.isViewAvailable;
        }

        public String getTaskAvatar() {
            return this.taskAvatar;
        }

        public String getViewAvatar() {
            return this.viewAvatar;
        }

        public void setEmails(String emails) {
            this.emails = emails;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public void setCompactTemplate(String compactTemplate) {
            this.compactTemplate = compactTemplate;
        }

        public void setDefaultView(String defaultView) {
            this.defaultView = defaultView;
        }

        public void setNotifs(String notifs) {
            this.notifs = notifs;
        }

        public void setBlockChangeNotifs(String blockChangeNotifs) {
            this.blockChangeNotifs = blockChangeNotifs;
        }

        public void setLaguage(String laguage) {
            this.laguage = laguage;
        }

        public void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public void setDefaultViewName(String defaultViewName) {
            this.defaultViewName = defaultViewName;
        }

        public void setViewAvailable(boolean isViewAvailable) {
            this.isViewAvailable = isViewAvailable;
        }

        public void setTaskAvatar(String taskAvatar) {
            this.taskAvatar = taskAvatar;
        }

        public void setViewAvatar(String viewAvatar) {
            this.viewAvatar = viewAvatar;
        }
    }

    public static class SkinDto {
        private String skinName;

        public String getSkinName() {
            return this.skinName;
        }

        public void setSkinName(String skinName) {
            this.skinName = skinName;
        }

        @ConstructorProperties(value={"skinName"})
        public SkinDto(String skinName) {
            this.skinName = skinName;
        }
    }
}

