/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.user.UserAvatarProperties;
import com.suncode.pwfl.administration.user.UserAvatarService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.core.context.ContextNotActiveException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.administration.user.UserAvatarInfoDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.ui.DivanteColor;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"users/avatar"})
public class UserAvatarController {
    private static final Logger log = LoggerFactory.getLogger(UserAvatarController.class);
    @Autowired
    private UserAvatarService userAvatarService;
    @Autowired
    private UserInfoCache userInfoCache;
    @Autowired
    private MessageHelperBean messageHelper;

    @RequestMapping
    @ResponseBody
    public byte[] getAvatar(@RequestParam(value="userName") String userName, @RequestParam(value="miniAvatar") boolean miniAvatar, @RequestParam(required=false) Integer maxAge, HttpServletResponse response) {
        if (maxAge != null) {
            response.setHeader("Cache-Control", "max-age=" + maxAge);
        }
        Optional avatar = this.userAvatarService.getUserAvatarImage(userName, miniAvatar);
        return avatar.orElseGet(() -> UserAvatarProperties.DEFAULT_AVATAR);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> handleAvatarUpload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="x") Integer x, @RequestParam(value="y") Integer y, @RequestParam(value="w") Integer width, @RequestParam(value="h") Integer height) {
        if (file.getSize() > 0x500000L) {
            return new ResponseEntity((Object)(this.messageHelper.getMessage("Maksymalny_rozmiar_pliku_MB") + ": 5"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        String mimeType = Tools.MIMETYPES_FILE_TYPE_MAP.getContentType(file.getOriginalFilename());
        if (!mimeType.startsWith("image/")) {
            return new ResponseEntity((Object)this.messageHelper.getMessage("Nieoprawny_typ_pliku"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (!file.isEmpty()) {
            Rectangle rect = new Rectangle(new Point(x, y));
            rect.width = width;
            rect.height = height;
            try {
                Optional avatar = this.userAvatarService.saveUserAvatar(UserContext.current().getUser().getUserName(), file.getBytes(), rect);
                if (avatar.isPresent()) {
                    return new ResponseEntity((Object)((byte[])avatar.get()), (HttpStatusCode)HttpStatus.OK);
                }
            }
            catch (ContextNotActiveException | IOException e) {
                log.error("Cannot save avatar: " + e.getMessage());
                return new ResponseEntity((Object)this.messageHelper.getMessage("Blad_zapisu_awatara"), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((Object)this.messageHelper.getMessage("Nie_wybrano_pliku"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteAvatar() {
        String userName = UserContext.current().getUser().getUserName();
        this.userAvatarService.resetAvatar(userName);
        return new RestResult(true);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"backgroundColor"})
    @ResponseBody
    public RestResult changeBackgroundColor(@RequestParam String backgroundColor) {
        String userName = UserContext.current().getUser().getUserName();
        this.userAvatarService.changeBackgroundColor(userName, DivanteColor.fromCode((String)backgroundColor));
        return new RestResult(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"backgroundColor"})
    @ResponseBody
    public DivanteColor getCurrentUserBackgroundColor() {
        return this.userAvatarService.getUserBackgroundColor(UserContext.current().getUser().getUserName());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"info"})
    @ResponseBody
    public UserAvatarInfoDto getUserAvatarInfo(@RequestParam String userName) {
        UserInfo userInfo = this.userInfoCache.get(userName);
        return UserAvatarInfoDto.builder().userName(userName).fullName(userInfo.getFullName()).hasAvatar(this.userAvatarService.hasAvatar(userName)).backgroundColor(this.userAvatarService.getUserBackgroundColor(userName).getCode()).build();
    }
}

