/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.notifications.NotificationDefTable;
import com.plusmpm.database.notifications.NotificationProcActTable;
import com.plusmpm.database.notifications.NotificationRecipientTable;
import com.plusmpm.i18n.I18N;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.ActivityVariable;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.NotificationActivityInfo;
import com.plusmpm.util.NotificationInfo;
import com.plusmpm.util.NotificationRecipientInfo;
import com.plusmpm.util.ProcessVariableHelper;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.XpdlPackageManager;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.context.i18n.LocaleContextHolder;

public class EditNotificationAction
extends Action {
    public static Logger log = Logger.getLogger(EditNotificationAction.class);
    private static I18N oMessage = new I18N();

    public static ArrayList<NotificationActivityInfo> getNotificationActivityInfo(String notificationDefId, HttpSession session) {
        log.info((Object)"****************************** EditNotificationAction.getNotificationActivityInfo *********************************");
        try {
            I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
            DBManagement dbManagement = new DBManagement();
            String procTypeId = ((NotificationProcActTable)dbManagement.getNotificationProcActByNotificationDefId(notificationDefId).get(0)).getProcessDefId();
            WorkflowProcess wp = SharkFunctions.getWorkflowProcessByDefId((String)procTypeId);
            String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(procTypeId);
            ArrayList alNotificationProcAct = dbManagement.getNotificationProcActByNotificationDefId(notificationDefId);
            ArrayList<NotificationActivityInfo> alNotificationActivityInfo = new ArrayList<NotificationActivityInfo>();
            for (int x = 0; x < alNotificationProcAct.size(); ++x) {
                NotificationActivityInfo notificationActivityInfo = new NotificationActivityInfo();
                notificationActivityInfo.setM_sNotificationDefId(notificationDefId);
                NotificationProcActTable notificationProcActTable = (NotificationProcActTable)alNotificationProcAct.get(x);
                notificationActivityInfo.setM_sNotificationProcActDefId(notificationProcActTable.getId().toString());
                Activity activity = wp.getActivity(notificationProcActTable.getActivityDefId());
                if (activity == null) continue;
                String key = XpdlKey.forPackage((String)packageId).forProcess(procTypeId).forActivity(activity.getId()).getKey();
                notificationActivityInfo.setM_sNotificationActivityId(activity.getId());
                notificationActivityInfo.setM_sNotificationActivityName(xpdl.getString(key));
                alNotificationActivityInfo.add(notificationActivityInfo);
            }
            return alNotificationActivityInfo;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ArrayList<NotificationRecipientInfo> getNotificationRecipientInfo(String notificationDefId) {
        log.info((Object)"****************************** EditNotificationAction.getNotificationRecipientInfo *********************************");
        try {
            DBManagement dbManagement = new DBManagement();
            ArrayList alNotificationRecipient = dbManagement.getNotificationRecipientByNotificationDefId(notificationDefId);
            ArrayList<NotificationRecipientInfo> alNotificationRecipientInfo = new ArrayList<NotificationRecipientInfo>();
            for (int z = 0; z < alNotificationRecipient.size(); ++z) {
                NotificationRecipientTable notificationRecipientTable = (NotificationRecipientTable)alNotificationRecipient.get(z);
                NotificationRecipientInfo notificationRecipientInfo = new NotificationRecipientInfo();
                notificationRecipientInfo.setM_sNotificationRecipientId(notificationRecipientTable.getId().toString());
                notificationRecipientInfo.setM_sNotificationDefId(notificationDefId);
                String type = notificationRecipientTable.getRecipientType();
                if (type.compareTo("user") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientType(oMessage.getString("Uzytkownik"));
                } else if (type.compareTo("userVariable") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientType(oMessage.getString("Uzytkownik") + " (" + oMessage.getString("Zmienna") + ")");
                } else if (type.compareTo("group") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientType(oMessage.getString("Grupa"));
                } else if (type.compareTo("participant") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientType(oMessage.getString("Wykonawca"));
                } else if (type.compareTo("allparticipants") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientType(oMessage.getString("Wykonawcy"));
                } else if (type.compareTo("position") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientType(oMessage.getString("Stanowisko"));
                } else if (type.compareTo("participanthigherposition") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientType(oMessage.getString("Przelozony"));
                }
                notificationRecipientInfo.setM_sNotificationRecipient(notificationRecipientTable.getRecipientVal());
                if (!Tools.isNullOrEmpty((String)notificationRecipientTable.getRecipientExcluded()) && notificationRecipientTable.getRecipientExcluded().compareToIgnoreCase("true") == 0) {
                    notificationRecipientInfo.setM_sNotificationRecipientExcluded(oMessage.getString("Tak"));
                } else {
                    notificationRecipientInfo.setM_sNotificationRecipientExcluded(oMessage.getString("Nie"));
                }
                alNotificationRecipientInfo.add(notificationRecipientInfo);
            }
            return alNotificationRecipientInfo;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"****************************** EditNotificationAction *********************************");
        try {
            String username;
            HttpSession session = request.getSession(false);
            String string = username = session != null ? (String)session.getAttribute("username") : null;
            if (session == null || username == null) {
                return mapping.findForward("disconnect");
            }
            if (!Authorization.checkIsUserAdmin((String)username)) {
                return mapping.findForward("welcome");
            }
            String notificationDefId = request.getParameter("notificationDefId");
            if (notificationDefId != null && notificationDefId.trim().compareToIgnoreCase("") != 0) {
                session.setAttribute("notificationDefId", (Object)notificationDefId);
            } else {
                notificationDefId = (String)session.getAttribute("notificationDefId");
            }
            DBManagement dbManagement = new DBManagement();
            String procTypeId = ((NotificationProcActTable)dbManagement.getNotificationProcActByNotificationDefId(notificationDefId).get(0)).getProcessDefId();
            String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(procTypeId);
            WorkflowProcess wp = SharkFunctions.getWorkflowProcessByDefId((String)procTypeId);
            NotificationDefTable notificationDef = dbManagement.getNotificationDefById(notificationDefId);
            if (notificationDef != null) {
                NotificationInfo notificationInfo = new NotificationInfo();
                notificationInfo.setM_sNotificationDefId(notificationDef.getId().toString());
                String conditionType = notificationDef.getConditionType();
                notificationInfo.setM_sNotificationDefConditionType(conditionType);
                Map allVariablesMap = wp.getAllVariables();
                DataField dataField = (DataField)allVariablesMap.get(notificationDef.getConditionVarName());
                if (dataField != null) {
                    notificationInfo.setM_sNotificationDefConditionVarName(dataField.getName());
                } else {
                    notificationInfo.setM_sNotificationDefConditionVarName(oMessage.getString("n_a"));
                }
                notificationInfo.setM_sNotificationDefConditionVal(notificationDef.getConditionVal());
                notificationInfo.setM_sNotificationDefName(notificationDef.getName());
                notificationInfo.setM_sNotificationDefSubject(notificationDef.getSubject());
                notificationInfo.setM_sNotificationDefTemplatePath(notificationDef.getTemplatePath());
                notificationInfo.setM_sNotificationDefRecipientPerformer(this.getCheckBoxValue(notificationDef.getRecipientPerformer()));
                notificationInfo.setM_sNotificationDefDontSendOnWeekends(this.getCheckBoxValue(notificationDef.getDontSendOnWeekends()));
                notificationInfo.setM_sNotificationDefDontSendOnHolidaysAndDaysOff(this.getCheckBoxValue(notificationDef.getDontSendOnHolidaysAndDaysOff()));
                ProcessVariableHelper processVariableHelper = new ProcessVariableHelper();
                ArrayList<ActivityVariable> alVars = processVariableHelper.getVariablesForProcess(procTypeId);
                request.setAttribute("notificationInfo", (Object)notificationInfo);
                request.setAttribute("alNotificationRecipientInfo", EditNotificationAction.getNotificationRecipientInfo(notificationDefId));
                request.setAttribute("alNotificationActivityInfo", EditNotificationAction.getNotificationActivityInfo(notificationDefId, session));
                request.setAttribute("procTypeId", (Object)procTypeId);
                request.setAttribute("variables", alVars);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        String displayTagRequest = request.getParameter("notificationActivities");
        if (displayTagRequest != null && displayTagRequest.compareToIgnoreCase("true") == 0) {
            return mapping.findForward("showNewNotificationActivity");
        }
        displayTagRequest = request.getParameter("notificationRecipients");
        if (displayTagRequest != null && displayTagRequest.compareToIgnoreCase("true") == 0) {
            return mapping.findForward("showNewNotificationRecipient");
        }
        return mapping.findForward("showEditNotification");
    }

    private String getCheckBoxValue(Boolean checkBoxValue) {
        if (checkBoxValue != null) {
            return checkBoxValue.toString();
        }
        return "false";
    }
}

