/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.struts.action.ProcesActivityAction;
import com.plusmpm.struts.action.ShowArchiveViewsAction;
import com.plusmpm.struts.form.CheckInFileForm;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.exception.FileSizeLimitExceededException;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.util.SpringContext;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

public class CheckInFileSubmitAction
extends Action {
    private static Logger log = Logger.getLogger(CheckInFileSubmitAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        boolean success;
        CheckInFileForm checkInForm;
        block13: {
            checkInForm = (CheckInFileForm)form;
            String userName = (String)request.getSession().getAttribute("username");
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            WfFileVersion fileVersion = fs.getVersionForFile(checkInForm.getFileId());
            success = false;
            if (fileVersion.getState().equals(WfFileVersion.State.STATE_EDIT.toString())) {
                if (userName.equals(fileVersion.getCheckOutUserName())) {
                    if (Authorization.hasRightsToModifyFile((String)UserContext.current().getUser().getUserName(), (Long)fileVersion.getFile().getDocumentClass().getId())) {
                        FormFile ff = checkInForm.getTheFile();
                        Long parentFileId = checkInForm.getFileId();
                        String prevDescription = fileVersion.getNewestFile().getDescription();
                        InputStream is = null;
                        try {
                            is = ff.getInputStream();
                            DocumentDefinition fd = new DocumentDefinition();
                            fd.setFileName(ff.getFileName());
                            fd.setUserName(userName);
                            fd.setInputStream(is);
                            if (StringUtils.isNotEmpty((CharSequence)prevDescription)) {
                                fd.setDescription(prevDescription);
                            }
                            fs.checkIn(fd, parentFileId, checkInForm.getComment());
                            success = true;
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                            if (e.getCause() instanceof FileSizeLimitExceededException) {
                                request.setAttribute("message", (Object)"Przekroczono_maksymalny_rozmiar_pliku.");
                                break block13;
                            }
                            request.setAttribute("message", (Object)"B\u0142\u0105d wysy\u0142ania pliku");
                        }
                    } else {
                        request.setAttribute("message", (Object)"Brak_uprawnien_aby_modyfikowac_plik");
                    }
                } else {
                    request.setAttribute("message", (Object)"Plik_jest_w_trakcie_edycji_inny_uzytkownik");
                }
            } else {
                request.setAttribute("message", (Object)"Plik_nie_jest_w_stanie_edycji");
            }
        }
        request.setAttribute("audit", (Object)this.buildAudit(success, checkInForm));
        String forward = checkInForm.getForward();
        if (forward != null && forward.compareToIgnoreCase("task") == 0) {
            try {
                ProcesActivityAction procesActivityAction = new ProcesActivityAction();
                request.setAttribute("processKey", (Object)checkInForm.getProcessId());
                request.setAttribute("activityId", (Object)checkInForm.getProcessId());
                return procesActivityAction.execute(mapping, form, request, response);
            }
            catch (Exception procesActivityAction) {
                // empty catch block
            }
        }
        ShowArchiveViewsAction showArchiveViewsAction = new ShowArchiveViewsAction();
        return showArchiveViewsAction.execute(mapping, form, request, response);
    }

    private AuditWrapper buildAudit(boolean success, CheckInFileForm form) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("docclassId", form.getDocclassId());
        params.put("documentId", form.getDocumentId());
        params.put("fileId", form.getFileId());
        params.put("processId", form.getProcessId());
        params.put("activityId", form.getActivityId());
        params.put("forward", form.getForward());
        params.put("description", form.getDescription());
        params.put("comment", form.getComment());
        return AuditBuilder.getInstance().params(params).type(AuditTypes.AUDIT_CHECK_IN_DOCUMENT_FROM_ARCHIVE).success(success).build();
    }
}

