(function (Ext) {
  Ext.define('Suncode.dashboard.settings.store.Dashboards', {
    extend: 'Ext.data.Store',
    model: 'Suncode.dashboard.settings.model.Dashboard',

    pageSize: 50,

    proxy: {
        type: 'ajax',
        url: Suncode.context('dashboard').base + '/api/dashboards/query',
        extraParams: {
            type: 'all',
        },
        simpleSortMode: true,
        reader: {
            type: 'json',
            root: 'data',
        },
    },
      listeners: {
          load: function (store) {
              store.each(function (record) {
                  const encodedName = Ext.util.Format.htmlEncode(record.get('translatedName'));
                  record.set('translatedName', encodedName);
              });
          }
      }
  });
})(Ext4);
