(function(Ext, messages) {

	Ext.define('Suncode.pluginmanager.view.Viewport', {
		extend : 'Ext.panel.Panel',
		alias : 'widget.pluginmanager-viewport',
		requires : [
				'Suncode.pluginmanager.view.InstallForm',
				'Suncode.pluginmanager.view.PluginList',
				'Suncode.pluginmanager.view.PluginDetails',
				'Suncode.pluginmanager.view.Requirements',
				'Suncode.pluginmanager.view.PluginSystemStartupError',
				'Suncode.pluginmanager.view.PluginClusterStatus',
				'Suncode.pluginmanager.view.PluginStatusTemplate',
		],
		layout : 'border',
		style : {
			margin : '10px 0 0 0',
			background : 'none'
		},
		bodyStyle: {
			border: 'none'
		},
		height : 700,
		minWidth : 400,

		items : [ {
			xtype : 'panel',
			width : 470,
			region : 'west',
			split: true,
			frame: true,
			layout : {
				type : 'vbox',
				align : 'stretch'
			},
			autoScroll: true,
			padding: '5px',
			bodyStyle : {
				border: '0'
			},
			defaults : {
				bodyPadding: 10,
				cls : 'panel-clear'
			},
			items : [ {
				xtype : 'pluginmanager-details',
				cls : 'panel-clear highlighted',
				hidden : true
			}, {
				xtype : 'pluginmanager-installer'
			}, {
				xtype : 'pluginmanager-systemstartuperror',
				hidden: true
			} ]
		}, {
			xtype : 'pluginmanager-pluginlist',
			region : 'center',
			store : 'Suncode.pluginmanager.store.Plugins'
		} ]
	});

}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));