(function(Ext, messages) {

	Ext.define('Suncode.pluginmanager.view.UpdateForm', {
		extend : 'Ext.form.Panel',
		alias : 'widget.pluginmanager-updater',
		layout: 'form',
		floating: true,
		frame: true,
		width: 350,
		
		initComponent : function() {
	        var me = this;
	        
	        Ext.apply(me, {
	        	items: [{
	    	        xtype: 'container',
	    	        layout: 'hbox',
	    	        items: [{
		    	    	xtype: 'filefield',
		    	    	name: 'file',
		    	    	flex: 1,
		    	    	margin: '0 10 0 0',
		    	    	allowBlank: false,
		    	    	regex: new RegExp('.jar$', 'i'),
		    	        buttonText: '',
						regexText: messages('error.nojar'),
						reset: function(force){
							if(force) {
								Ext.form.field.File.prototype.reset.call(this);
							}
						}
		    	    }, {
		    	        xtype: 'button',
		    	        text: messages('update'),
		    	        iconCls: 'dvnt-icon-edit-form',
		    	        formBind: true,
		    	        handler: function(){
		    	    	    if(this.getForm().isValid()){
		    	    	        this.doUpdate();
		    	    	    }
		    	        },
		    	        scope: this
		    	    }, {
		    	        xtype: 'button',
		    	        text: messages('cancel'),
		    	        handler: function(){
		    	    	    me.hide();
    	    	        }
		    	    }]
    	        }],
	        });

	        me.callParent(arguments);
		
			me.fileInput = me.down("filefield")
		},
		
		update: function(plugin){
		    var me = this;
		    
		    me.showBy( me.alignComponent, me.alignType);
		    me.updatedPlugin = plugin;
		},
		
		doUpdate: function(){
		    var me = this,
		        filename = me.getForm().getFields().get(0).getValue().replace(/^.*[\\\/]/, '');
		    
		    me.fireEvent('update', me.updatedPlugin, me.getForm(), filename);
		    me.hide();
		},

		onShow: function(){
		    this.fileInput.reset(true)
		    this.getForm().isValid();
            delete this.updatedPlugin;
            
		    this.callParent(arguments);
		    this.mon(Ext.getDoc(), 'mousedown', this.onDocMouseDown, this);
		},

        onHide: function(){
            this.callParent(arguments);
            this.mun(Ext.getDoc(), 'mousedown', this.onDocMouseDown, this);
        },
        
        onDocMouseDown: function(e){
        	if(!e.within(this.el.dom)){
        	    this.hide();
        	}
        }

	});

}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));