(function(Ext) {

  Ext.define('Suncode.pluginmanager.view.PluginStatusTemplate', {
    singleton: true,

    render(record) {
      const status = record.get('status');
      const pluginEnabled = record.get('enabled');
      const allSynced = status.synced === status.total;
      const someSynced = status.synced > 0 && status.synced < status.total;
      const noneSynced = status.synced === 0;

      const colorClass =
        someSynced && 'dvnt-orange' ||
        noneSynced && 'dvnt-red';
      const iconClass =
        pluginEnabled && allSynced && 'dvnt-icon-check-circle dvnt-green-icon' ||
        someSynced && 'dvnt-icon-exclamation-triangle dvnt-orange-icon' ||
        noneSynced && 'dvnt-icon-x-circle dvnt-red-icon' ||
        '';

      return status.total === 1
        ? icon(iconClass)
        : `<span>
             <span id="synced-count" class="${colorClass}">${status.synced}</span>
             <span class="">/</span>
             <span id="total-count"">${status.total}</span>
            
             ${icon(iconClass)}
          </span>`;
    },
  });


  function icon(cls) {
    return `<span style="vertical-align: middle;">
             <img src="${Ext.BLANK_IMAGE_URL}" class="${cls}" style="height: 16px; width:16px;" />
           </span>`;
  }

}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));