(function(Ext, messages) {
    
	Ext.define('Suncode.pluginmanager.view.PluginList', {
		extend: 'Ext.grid.Panel',
		alias: 'widget.pluginmanager-pluginlist',
		title: messages('view.list.title'),
		
		selModel: {
			allowDeselect: false
		},
		viewConfig: {
			markDirty: false,
      getRowClass: function( record, index, rowParams, store ) {
			    return record.noneSynced() && 'plugin-list-error'
            || record.partiallySynced() && 'plugin-list-warning';
			}
		},
		tools: [{
			type:'refresh',
            width: '20px',
			height: '20px',
			callback: function(panel){
				panel.store.load();
			}
		}],
		    
		initComponent: function(){
		    Ext.apply(this, {
                columns: [
                    {
                        xtype: 'rownumberer',
                        minWidth: 50
                    },
                    {
                        text: messages('plugin.name'),
                        dataIndex: 'name',
                        flex: 1
                    },
                    {
                        text: messages('plugin.version'),
                        dataIndex: 'version',
                        width: 100
                    },
                    {
                        text: messages('plugin.key'),
                        dataIndex: 'key',
                        flex: 2
                    },
                    {
                        text: messages('plugins.view.information.license'),
                        dataIndex: 'license',
                        width: 200
                    },
                    {
                        text: messages('plugin.enabled'),
                        dataIndex: 'enabled',
                        width: 120,
                        renderer: function (value, meta) {
                            var imgClass = value ? 'dvnt-icon-check-symbol dvnt-green-icon' : ''
                            meta.style = 'text-align: center;';
                            return '<img src="' + Ext.BLANK_IMAGE_URL + '" class="' + imgClass + '" style="height: 16px; width:16px;"/>';
                        }
                    },
                    {
                      text: messages('plugin.status'),
                      dataIndex: 'status',
                      width: 120,
                      renderer: function (value, meta, record) {
                        meta.style = 'text-align: center;';
                        return Suncode.pluginmanager.view.PluginStatusTemplate.render(record);
                      }
                    },
                    {
                        text: messages('plugin.lastupdate'),
                        width: 180,
                        dataIndex: 'updated',
                        xtype: 'datecolumn',
                        format: 'Y-m-d H:i:s'
                    }
                ]
		    });
		    
		    this.callParent(arguments);
		}
	});
}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));
