(function(Ext, messages) {
  Ext.define('Suncode.pluginmanager.view.PluginClusterStatus', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pluginmanager-pluginclusterstatus',
    cls: 'cluster-status',
    collapsible: true,
    collapsed: true,
    titleCollapse: true,
    animCollapse: false,
    frame: true,
    border: false,
    bodyBorder: false,
    padding: '0 10 0 10',

    update(plugin) {
      this.plugin = plugin;

      this.setTitle(
        `${messages('plugin.status')}: ${Suncode.pluginmanager.view.PluginStatusTemplate.render(plugin)}`
      );

      const nodes = plugin.get('status')['nodes'];
      Ext.suspendLayouts();
      this.removeAll();

      Object.keys(nodes).forEach((nodeId) => {
        this.add(
          this.createNodePanel(nodeId, nodes[nodeId])
        );
      });

      Ext.resumeLayouts();
    },

    createNodePanel(nodeId, status) {
      return Ext.create('Ext.panel.Panel', {
        margin: '10 0 10 0',
        bodyPadding: '5px',
        layout: {
          type: 'vbox',
          align: 'stretch',
          defaultMargins: "0 0 5 0",
        },
        frame: true,
        bodyBorder: false,
        border: false,
        header: {
          titlePosition: 1,
          items: [
            nodeName(nodeId, status),
            updatedTime(status),
            forceButton(status, (button) => this.fireEvent('increaserevision', this.plugin, () => {
              const previousIcon = button.iconCls
              button.setIconCls('dvnt-icon-check-symbol');
              button.disable();
              setTimeout(() => {
                button.setIconCls(previousIcon);
                button.enable();
              }, 5000);
            }))
          ]
        },
        items: [
          nodeProperty(messages('plugin.state'), status.state, (state) =>
            (state === 'ACTIVE' && messages('plugin.state.active')) || (state === 'STOPPED' && messages('plugin.state.stopped')) || ""
          ),
          nodeProperty(messages('plugin.version'), status.version),
          nodeProperty(messages('plugin.contentid'), status.contentId, null, true)
        ]
      });
    }
  });

  function nodeName(nodeId, status) {
    return {
      xtype: 'component',
      html: `${icon(`dvnt-icon-cpu ${status.synced ? 'dvnt-green-icon' : 'dvnt-red-icon'}`)} ${nodeId}`
    };
  }

  function updatedTime(status) {
    const now = new Date();
    const updated = new Date(status.updated);
    const elapsedSeconds = Math.floor((now.getTime() - updated.getTime()) / 1000);
    const outdated = elapsedSeconds > 600;
    return {
      xtype: 'component',
      html: `<span data-qtip="${messages("plugin.cluster.node.updated", updated.format('Y-m-d H:i:s'))}">
              ${icon(`dvnt-icon-clock ${outdated ? 'dvnt-orange-icon' : 'dvnt-green-icon'}`)}
            </span>`
    };
  }

  function forceButton(status, handler) {
    return {
        xtype: 'button',
        hidden: status.synced,
        tooltip: messages("plugin.cluster.node.resetattempts"),
        iconCls: 'dvnt-icon-rotation-right',
        handler: handler,
      };
  }

  function nodeProperty(name, value, valueFn, tooltip) {
    const actualValue = valueFn && valueFn(value.actual) || value.actual;
    const expectedValue = valueFn && valueFn(value.expected) || value.expected;
    return {
      xtype: 'component',
      html: `${value.synced ? iconCheck() : iconCross()}
              ${name}: 
              <span class="property-value${!value.synced ? " dvnt-red" : ""}" ${tooltip && actualValue && qtip(actualValue) || ''}>${actualValue || 'none'}</span>
              ${!value.synced ? `<span>≠</span> <span class="property-value" ${tooltip && expectedValue && qtip(expectedValue) || ''}>${expectedValue || 'none'}</span>` : ""}
            `
    };
  }

  function qtip(tooltip) {
    return `data-qtip="${tooltip}"`
  }

  function iconCheck() {
    return icon('dvnt-icon-check-circle dvnt-green-icon');
  }

  function iconCross() {
    return icon('dvnt-icon-x-circle dvnt-red-icon');
  }

  function icon(cls) {
    return `<img src="${Ext.BLANK_IMAGE_URL}" class="${cls}" style="height: 20px; width:20px; vertical-align: middle"/>`;
  }

}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));