(function(Ext) {

	Ext.define('Suncode.pluginmanager.model.Plugin', {
		extend : 'Ext.data.Model',
		idProperty: 'key',
		
		fields : [ {
			name : 'key',
			type : 'string'
		},{
			name : 'enabled',
			type : 'boolean',
			defaultValue: false
		},{
			name : 'name',
			type : 'string'
		},{
			name : 'version',
			type : 'string'
		},{
			name : 'description',
			type : 'string'
		},{
			name : 'author',
			type : 'string'
		},{
			name : 'license',
			type : 'string'
		}, {
			name : 'updated',
			type : 'date',
			dateFormat: 'time'
		}, {
			name : 'systemStartupError',
			type : 'string'
		}, {
			name : 'status',
			type : 'object'
		}],

		getKey: function(){
	        return this.get('key');
	    },

		isEnabled: function(){
			return this.get('enabled');
		},

		partiallySynced: function() {
			const status = this.get('status');
			return status.synced < status.total;
		},

		noneSynced: function() {
			return this.get('status').synced === 0;
		},

		hasErrorWhileSystemStartup: function() {
			return !!this.get('systemStartupError')
		}
	});

})(Ext4);