Ext4.define('Suncode.passwordpolicy.view.ProfilesAssignmentGrid', {
	extend: 'Ext.grid.Panel',

	alias: 'widget.passwordpolicy-profilesassignment',

	requires: 'Ext.ux.grid.FiltersFeature',

	title: PW.t('Przypisanie_grup_do_profili'),

	height: 755,

	notChoosenProfileText: PW.t('Nie_wybrano'),

	plugins: [{
		ptype: 'cellediting',
		clicksToEdit: 1
	}],

	features: [{
		ftype: 'filters',
		autoReload: false,
		local: true,
		filters: [{
			type: 'string',
			dataIndex: 'groupName'
		}]
	}],

	initComponent: function () {
		var me = this;
		Ext4.apply(this, {
			columns: [{
				xtype: 'rownumberer'
			}, {
				text: PW.t('Grupa'),
				dataIndex: 'groupName',
				flex: 1
			}, {
				text: PW.t('Profil'),
				flex: 1,
				dataIndex: 'profileName',
				renderer: function (value) {
					if (value) {
						return value;
					}
					else {
						return '<p class="x4-form-empty-field">' + me.notChoosenProfileText + '</p>';
					}
				},
				editor: {
					xtype: 'combobox',
					store: 'Suncode.passwordpolicy.store.PasswordProfileStore',
					displayField: 'name',
					valueField: 'name',
					forceSelection: true,
					listeners: {
						select: function (combo, selectedProfiles) {
							var selected = combo.up('grid').getSelectionModel().selected;
							if (selected.length > 0 && selectedProfiles.length > 0) {
								var selectedAssignment = selected.getAt(0);
								var selectedProfile = selectedProfiles[0];

								selectedAssignment.updateAssignment(selectedProfile);
							}
						},
						change: function (combo, inputText) {
							if (!inputText) {
								var selected = combo.up('grid').getSelectionModel().selected;
								if (selected.length > 0) {
									var selectedAssignmention = selected.getAt(0);
									selectedAssignmention.clear();
								}
							}
						}
					}
				}
			}]
		});

		this.callParent(arguments);
	},

	reset: function () {
		this.store.load();
	}
});
