Ext4.define('Suncode.passwordpolicy.view.NewProfileConfigurationWindow', {
	extend : 'Ext.window.Window',

	alias : 'widget.passwordpolicy-newprofileconfiguration',

	title : PW.t('Dodawanie_nowego_profilu'),

	layout : 'fit',

	modal : true,

	items : [ {
		id : 'form',
		xtype : 'form',
		border: false,
		bodyPadding : '20 20',
		fieldDefaults : {
			labelAlign : 'left',
			labelWidth : 250,
			width: 450
		},
		items : [ {
			xtype : 'passwordpolicy-profileconfigurationform'
		} ]
	} ],

	initComponent : function() {
		var me = this;

		Ext4.apply(this, {
			buttons : [ {
				xtype : 'button',
				text : PW.t('Dodaj_profil'),
				iconCls : 'dvnt-icon-plus-circle',
				handler : me.addProfile,
				scope : this
			} ]
		});

		this.callParent(arguments);
	},

	addProfile : function() {
		var me = this;
		var form = me.items.get('form').getForm();

		if (form.isValid()) {
			var fields = form.getFields();
			var data = {};

			fields.items.forEach(function(field) {
				var key = field.name;
				var value = field.getValue();
				data[key] = value;
			})

			var mask = new Ext4.LoadMask({target: me});
			mask.show();

			jQuery.ajax({
				method: 'POST',
				url: 'api/password/policy/profile/create',
				data: JSON.stringify(data),
				contentType: 'application/json',
				complete: function() {
					mask.destroy();
				},
				success: function() {
					me.fireEvent('profileadded');
				},
				error: function(response) {
					if(response.responseJSON && response.responseJSON.errorMessage) {
						PW.ui.Message.error(response.responseJSON.errorMessage);
					}
					else {
						PW.ui.Message.error(PW.t('Wystapil_blad_podczas_dodawania_profilu'));
					}
				}
			})
		}
	}
});
