Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

Ext.ux.plusmpm.scheduledtasks.ParametersTableButtons = function (config) {
  var me = this;
  Ext.apply(config, {
    layout: 'hbox',
    width: 84,
    defaults: {
      margins: "0 0 4 0",
    },
    items: [
      {
        xtype: 'button',
        itemId: 'add-button',
        iconCls: 'dvnt-icon-plus-circle dvnt-green-icon',
        hideMode: 'visibility',
        ref: 'addButton',
        width: 42,
        height: 42,
        scale: 'medium',
        handler: function (button) {
          me.parametersTable.onAddRowClick(me.parametersTable.tableContainer.buttonsContainer.items.indexOf(me) + 1);
        },
      },
      {
        xtype: 'button',
        itemId: 'remove-button',
        iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
        hideMode: 'visibility',
        ref: 'removeButton',
        width: 42,
        height: 42,
        scale: 'medium',
        handler: function (button) {
          me.parametersTable.onRemoveRowClick(me.parametersTable.tableContainer.buttonsContainer.items.indexOf(me));
        },
        hidden: config.asPlaceholder,
      },
    ],
  });

  Ext.ux.plusmpm.scheduledtasks.ParametersTableButtons.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.ParametersTableButtons, Ext.Container, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.ParametersTableButtons.superclass.initComponent.call(this);
  },

  setAsPlaceholder: function () {
    this.removeButton.hide();

    this.asPlaceholder = true;
    this.parametersTable.doLayout();
  },

  setAsPresent: function () {
    this.removeButton.show();

    this.asPlaceholder = false;
    this.parametersTable.doLayout();
  },

  isPlaceholder: function () {
    return this.asPlaceholder;
  },

  setReadOnly: function (readOnly) {
    if (readOnly || this.disabled) {
      this.addButton.disable();
      this.removeButton.disable();
    } else {
      this.addButton.enable();
      this.removeButton.enable();
    }
  },

  setDisabled: function (disabled) {
    if (disabled) {
      this.addButton.disable();
      this.removeButton.disable();
    } else {
      this.addButton.enable();
      this.removeButton.enable();
    }
  },

  showButtons: function () {
    this.addButton.show();
    this.removeButton.show();
  },

  hideButtons: function () {
    this.addButton.hide();
    this.removeButton.hide();
  },
});

Ext.reg('st_parameterstablebuttons', Ext.ux.plusmpm.scheduledtasks.ParametersTableButtons);
