Ext.ux.plusmpm.scheduledtasks.ParametersTable = function (config) {
  config = Ext.apply(
    {
      items: [{
        xtype: 'container',
        layout: 'hbox',
        ref: "headerContainer",
        defaults: {
          margins: "5 0 0 0"
        },
        items: [{
          xtype: 'container',
          layout: 'hbox',
          ref: "labelContainer",
          flex: 1,
          items: [],
        }, {
          xtype: 'container',
          width: 84,
          height: 28,
        }]
      }, {
        xtype: 'container',
        layout: 'hbox',
        ref: "tableContainer",
        items: [{
          xtype: 'container',
          layout: 'hbox',
          ref: 'arrayFieldsContainer',
          autoHeight: true,
          items: [],
          flex: 1,
          defaults: {
            flex: 1,
            margins: '0 3 0 0',
          }
        }, {
          xtype: 'container',
          ref: 'buttonsContainer',
          items: []
        }]
      }]
    },
    config
  );

  Ext.ux.plusmpm.scheduledtasks.ParametersTable.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.ParametersTable, Ext.ux.plusmpm.scheduledtasks.ParametersContainer, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.ParametersTable.superclass.initComponent.call(this);
  },

  insertParameterCmp: function (position, paramCmpConfig, paramDefinition) {
    paramCmpConfig.renderButtons = false;
    var insertedCmp = this.tableContainer.arrayFieldsContainer.insert(position, paramCmpConfig);

    this.parametersBuilder.refreshLabel(this.tableContainer.arrayFieldsContainer, insertedCmp, paramDefinition);

    if (!this.editable) {
      insertedCmp.setDisabled(true);
    }

    this.synchronizeButtonsContainer();

    var label = {
      xtype: 'label',
      html: insertedCmp.fieldLabel + ":",
      height: 28,
      flex: 1
    }
    this.parametersBuilder.addDescriptionTooltipTo(label, insertedCmp.description)
    this.headerContainer.labelContainer.insert(position, label)

    return insertedCmp;
  },

  getParametersCount: function () {
    return this.tableContainer.arrayFieldsContainer.items?.length;
  },

  setDisabled: function (disabled) {
    this.tableContainer.arrayFieldsContainer.items.each(function (item) {
      item.setDisabled(disabled);
    }, this);
    this.tableContainer.buttonsContainer.items.each(function (item) {
      item.setDisabled(disabled);
    }, this);
  },

  onAddRowClick: function (position) {
    this.tableContainer.arrayFieldsContainer.items.each(function (arrayField) {
      arrayField.addRow(position);
    });
    this.tableContainer.arrayFieldsContainer.doLayout();

    this.synchronizeButtonsContainer();
  },

  onRemoveRowClick: function (position) {
    this.tableContainer.arrayFieldsContainer.items.each(function (arrayField) {
      arrayField.removeRow(position);
    });
    this.tableContainer.arrayFieldsContainer.doLayout();

    this.synchronizeButtonsContainer();
  },

  synchronizeButtonsContainer: function () {
    var me = this;

    var firstArrayFieldLength = this.tableContainer.arrayFieldsContainer.items.itemAt(0).getLength();
    firstArrayFieldLength = firstArrayFieldLength === 0 ? 1 : firstArrayFieldLength;

    // dodanie brakujących przycisków
    var buttonsContainerLength = this.tableContainer.buttonsContainer.items.getCount();
    if (firstArrayFieldLength > buttonsContainerLength) {
      for (var i = 0; i < (firstArrayFieldLength - buttonsContainerLength); ++i) {
        var buttons = new Ext.ux.plusmpm.scheduledtasks.ParametersTableButtons({
          parametersTable: this
        });
        this.tableContainer.buttonsContainer.add(buttons);
      }
    }

    // usuwanie nadmiarowych przycisków
    if (firstArrayFieldLength < buttonsContainerLength) {
      for (var i = 0; i < (buttonsContainerLength - firstArrayFieldLength); ++i) {
        var buttons = this.tableContainer.buttonsContainer.items.itemAt(0);
        this.tableContainer.buttonsContainer.remove(buttons);
      }
    }

    // ustawianie odpowiedniego stanu
    var firstArrayFieldIsNotEmpty = this.tableContainer.arrayFieldsContainer.items.itemAt(0).getLength() > 0;
    this.tableContainer.buttonsContainer.items.each(function (buttons) {
      if (firstArrayFieldIsNotEmpty) {
        buttons.setAsPresent();
      }
      else {
        buttons.setAsPlaceholder();
      }

      buttons.setDisabled(!me.editable);
    });

    this.tableContainer.buttonsContainer.doLayout();
  }

});
Ext.reg('st_parameterstable', Ext.ux.plusmpm.scheduledtasks.ParametersTable);
