Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

Ext.ux.plusmpm.scheduledtasks.RemovableField = function (config) {
  config.fieldConfig = Ext.apply({}, config.fieldConfig);

  var paramData = config.paramData;
  if (config.fieldConfig.requiresParamData) {
    Ext.apply(config.fieldConfig, {
      paramData: paramData,
    });
  } else {
    Ext.apply(config.fieldConfig, paramData.valueInfo);
    Ext.apply(config.fieldConfig, paramData.fieldInfo);
  }

  var me = this;
  Ext.apply(config, {
    layout: 'hbox',
    items: [
      {
        xtype: 'container',
        ref: 'fieldContainer',
        layout: 'fit',
        flex: 1,
        height: 40,
        items: [config.fieldConfig],
        defaults: {
          disabled: config.asPlaceholder,
          flex: 1,
        },
        margins: '0 2 2 0',
      },
      {
        xtype: 'button',
        itemId: 'add-button',
        iconCls: 'dvnt-icon-plus-circle dvnt-green-icon',
        hideMode: 'visibility',
        ref: 'addButton',
        width: 42,
        height: 42,
        scale: 'medium',
        handler: function (button) {
          me.arrayField.onAddRowClick(me.arrayField.items.indexOf(me) + 1);
        },
        hidden: !config.renderButtons,
      },
      {
        xtype: 'button',
        itemId: 'remove-button',
        iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
        hideMode: 'visibility',
        ref: 'removeButton',
        width: 42,
        height: 42,
        scale: 'medium',
        handler: function (button) {
          me.arrayField.onRemoveRowClick(me.arrayField.items.indexOf(me));
        },
        hidden: config.asPlaceholder || !config.renderButtons,
      },
    ],
  });

  Ext.ux.plusmpm.scheduledtasks.RemovableField.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.RemovableField, Ext.Container, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.RemovableField.superclass.initComponent.call(this);
    this.getField().on('change', this.onInternalValueChange, this);
    this.addEvents('change');
  },

  setAsPlaceholder: function () {
    var field = this.fieldContainer.items.items[0];
    field.disable();
    field.setValue('');
    if (this.renderButtons) {
      this.removeButton.hide();
    }

    this.asPlaceholder = true;
    this.arrayField.doLayout();
  },

  setAsField: function () {
    this.fieldContainer.items.items[0].enable();
    if (this.renderButtons) {
      this.removeButton.show();
    }
    this.asPlaceholder = false;
    this.arrayField.doLayout();
  },

  isPlaceholder: function () {
    return this.asPlaceholder;
  },

  getValue: function () {
    return this.getField().getValue();
  },

  setValue: function (value) {
    this.getField().setValue(value);
  },

  setRequired: function (isRequired) {
    var field = this.getField();
    if (field.setRequired) {
      field.setRequired(isRequired);
    } else {
      field.allowBlank = !isRequired;
    }
  },

  onInternalValueChange: function (field) {
    this.fireEvent('change', field);
  },

  setReadOnly: function (readOnly) {
    this.getField().setReadOnly(readOnly);
    if (readOnly || this.disabled) {
      this.addButton.disable();
      this.removeButton.disable();
    } else {
      this.addButton.enable();
      this.removeButton.enable();
    }
  },

  setDisabled: function (disabled) {
    this.getField().setDisabled(disabled);
    if (disabled || this.readOnly) {
      this.addButton.disable();
      this.removeButton.disable();
    } else {
      this.addButton.enable();
      this.removeButton.enable();
    }
  },

  setComboboxRemoteUrl: function (url) {
    var combobox = this.getField();
    if (combobox.mode != 'remote') {
      return;
    }

    var jsonStore = combobox.getStore();
    jsonStore.removeAll();
    jsonStore.url = url
    jsonStore.proxy.setUrl(url, true);
    jsonStore.load();

    combobox.setValue('');
  },

  setComboboxRemoteParams: function (params) {
    var combobox = this.getField();
    if (combobox.mode != 'remote') {
      return;
    }

    var jsonStore = combobox.getStore();
    jsonStore.removeAll();
    jsonStore.baseParams = params || {};
    jsonStore.load();

    combobox.setValue('');
  },

  getField: function () {
    return this.fieldContainer.items.items[0];
  },

  showButtons: function () {
    if (!this.renderButtons) {
      return;
    }
    this.addButton.show();
    this.removeButton.show();
  },

  hideButtons: function () {
    if (!this.renderButtons) {
      return;
    }
    this.addButton.hide();
    this.removeButton.hide();
  },
});

Ext.reg('st_removablefield', Ext.ux.plusmpm.scheduledtasks.RemovableField);
