Ext.ux.plusmpm.scheduledtasks.ParametersFieldSet = function (config) {
  config = Ext.apply(
    {
      labelWidth: 250,
      layout: {
        type: 'form',
        trackLabels: true,
      },
      defaults: {
        labelWidth: 250,
        anchor: '100%',
        allowBlank: false,
      },
    },
    config
  );

  Ext.ux.plusmpm.scheduledtasks.ParametersFieldSet.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.ParametersFieldSet, Ext.form.FieldSet, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.ParametersFieldSet.superclass.initComponent.call(this);
  },

  addParameter: function (paramDefinition) {
    var lastPosition = this.items.length;

    var parameterCmpConfig = this.parametersBuilder.createParameter(paramDefinition);
    this.insertParameterCmp(lastPosition, parameterCmpConfig, paramDefinition);
  },

  insertParameterCmp: function (position, paramCmpConfig, paramDefinition) {
    var insertedCmp = this.insertSimpleCmp(position, paramCmpConfig);
    this.parametersBuilder.refreshLabel(this, insertedCmp, paramDefinition);

    return insertedCmp;
  },

  insertSimpleCmp: function (position, cmpConfig) {
    var insertedCmp = this.insert(position, cmpConfig);

    if (!this.editable) {
      insertedCmp.setDisabled(true);
    }

    return insertedCmp;
  },

  getParametersCount: function () {
    return this.items.length;
  },

  setDisabled: function (disabled) {
    this.items.each(function (item) {
      item.setDisabled(disabled);
    }, this);
  },
});
Ext.reg('st_fieldset', Ext.ux.plusmpm.scheduledtasks.ParametersFieldSet);
