Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

Ext.ux.plusmpm.scheduledtasks.ArrayFieldComponent = function (config) {
  var me = this;

  var items = [
    {
      xtype: 'removablefield',
      arrayField: this,
      asPlaceholder: true,

      cls: 'x-form-item',

      fieldConfig: config.fieldConfig,

      listeners: {
        scope: me,
        change: me.onRowFieldChanged,
      },
    },
  ];

  if (!Ext.isEmpty(config.values)) {
    items = [];
    for (var i = 0; i < config.values.length; ++i) {
      var removableField = {
        xtype: 'removablefield',
        arrayField: this,
        asPlaceholder: false,
        value: config.values[i],

        cls: 'x-form-item',

        fieldConfig: config.fieldConfig,

        listeners: {
          scope: me,
          change: me.onRowFieldChanged,
        },
      };

      items.push(removableField);
    }
  }

  Ext.apply(config, {
    autoHeight: true,
    items: items,
  });

  Ext.ux.plusmpm.scheduledtasks.ArrayFieldComponent.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.ArrayFieldComponent, Ext.Container, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.ArrayFieldComponent.superclass.initComponent.call(this);
    this.setDisabled(this.disabled)
    this.addEvents('change');
  },

  getValue: function () {
    var values = [];
    for (var removableField of this.items.items) {
      if (removableField.isPlaceholder()) {
        continue;
      }

      values.push(removableField.getValue());
    }
    return values;
  },

  setValue: function (values) {
    var rowsLen = this.getLength();

    if (values.length >= rowsLen) {
      for (var i = 0; i < values.length; ++i) {
        if (i >= rowsLen) {
          this.addRow();
        }

        this.items.items[i].setValue(values[i]);
      }
    } else {
      for (var i = 0; i < values.length; ++i) {
        this.items.items[i].setValue(values[i]);
      }

      var rowsToRemove = [];
      for (var i = values.length; i < rowsLen; ++i) {
        rowsToRemove.push(this.items.items[i]);
      }

      for (var row of rowsToRemove) {
        this.removeRow(row);
      }
    }
    this.fireEvent('change', this, this.getValue());
  },

  setReadOnly: function (readOnly) {
    this.readOnly = readOnly;
    for (var removableField of this.items.items) {
      removableField.setReadOnly(readOnly);
    }
  },

  setDisabled: function (disabled) {
    this.disabled = disabled;
    for (var removableField of this.items.items) {
      removableField.setDisabled(disabled);
    }
  },

  setRequired: function (isRequired) {
    for (var removableField of this.items.items) {
      removableField.setRequired(isRequired);
    }
  },

  addRow: function (position) {
    var me = this;
    var rowConfig = {
      xtype: 'removablefield',
      arrayField: this,
      asPlaceholder: false,

      cls: 'x-form-item',

      fieldConfig: this.fieldConfig,

      listeners: {
        scope: me,
        change: me.onRowFieldChanged,
      },
    };

    var rows = this.items.items;
    if (rows.length === 1 && rows[0].isPlaceholder()) {
      rows[0].setAsField();
      return;
    }

    var addedCmp;
    if (!position) {
      addedCmp = this.add(rowConfig);
    } else {
      addedCmp = this.insert(position, rowConfig);
    }

    if (this.readOnly) {
      addedCmp.setReadOnly(this.readOnly);
    }

    if (this.disabled) {
      addedCmp.setDisabled(this.disabled);
    }

    this.doLayout();
  },

  removeRow: function (row) {
    if (this.items.items.length == 1) {
      row.setAsPlaceholder();
    } else if (this.items.items.length > 1) {
      this.remove(row);
    }

    this.doLayout();
  },

  getLength: function () {
    var len = this.items.items.length;
    return this.items.items[0].isPlaceholder() ? 0 : len;
  },

  onAddRowClick: function (position) {
    this.addRow(position);
    this.fireEvent('change', this, this.getValue());
  },

  onRemoveRowClick: function (row) {
    this.removeRow(row);
    this.fireEvent('change', this, this.getValue());
  },

  onRowFieldChanged: function () {
    this.fireEvent('change', this, this.getValue());
  },
});

Ext.reg('arrayfield', Ext.ux.plusmpm.scheduledtasks.ArrayFieldComponent);