Ext.ux.plusmpm.scheduledtasks.BoundNumberField = function (config) {
  config = Ext.apply({
    boundComponentIds: []
  }, config)
  Ext.ux.plusmpm.scheduledtasks.BoundNumberField.superclass.constructor.call(this, config);
}

Ext.extend(Ext.ux.plusmpm.scheduledtasks.BoundNumberField, Ext.form.NumberField, {
  getErrors: function () {
    var errors = Ext.ux.plusmpm.scheduledtasks.BoundNumberField.superclass.getErrors.call(this);

    var anyFilled = false;
    var allFilled = true;

    for (var componentId of this.boundComponentIds) {
      var field = Ext.getCmp(componentId);

      if (!this._isBlank(field.getValue()))
      {
        anyFilled = true;
      }
      else
      {
        allFilled = false;
      }
    }

    if (!anyFilled || allFilled)
    {
      return errors;
    }

    errors.push(PW.t("eitherAllOrNoneOfFieldsMustBeFilled"));
    return errors;
  },

  _isBlank: function (value) {
    return value === undefined || value === null || value === "";
  },

  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.BoundNumberField.superclass.initComponent.call(this);
    this.on('change', function() {
      for (var componentId of this.boundComponentIds) {
        var field = Ext.getCmp(componentId);
        field.validate();
      }
    }, this)
  },
})

Ext.reg('st_bound_numberfield', Ext.ux.plusmpm.scheduledtasks.BoundNumberField);
