Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

/**
 * Toolbar filtrowania zadań zaplanowanych.
 * 
 * eventy:
 * 
 *  filter - zmienily sie kryteria wyszukiwania
 *  refresh - odśwież wszysktie zadania z tej kategorii
 *
 */
Ext.ux.plusmpm.scheduledtasks.TasksFilterToolbar = function(config) {
	
	config = Ext.apply({
		items: [{
			xtype: 'tbtext',
			text: PW.t('search') + ':'
		},' ',{
            xtype: 'textfield',
            emptyText: PW.t('search'),
            enableKeyEvents: true,
            ref: 'queryTextfield',
            listeners: {
            	keyup: this.onSearchQueryKeyup,
            	scope: this   	
            }
        },
				{
        	xtype: 'button',
            enableToggle: true,
            scope: this,
            ref: 'displayStaticIdButton',
            toggleHandler: this.onDisplayStaticIdToggle,
            pressed: false,
        	text: PW.t('displayStaticId')
        },				{
        	xtype: 'button',
            enableToggle: true,
            scope: this,
            ref: 'onlyActiveButton',
            toggleHandler: this.onOnlyActiveToggle,
            pressed: false,
        	text: PW.t('onlyActive')
        },
        {
        	xtype: 'button',
            enableToggle: true,
            scope: this,
            ref: 'onlyProcessingButton',
            toggleHandler: this.onOnlyProcessingToggle,
            pressed: false,
        	text: PW.t('onlyRunning')
        }
        ,'-',
        {
        	xtype: 'splitbutton',
            scope: this,
        	text: PW.t('sort') + ' ' + PW.t("descending"),
        	iconCls: 'dvnt-icon-down-straight',
        	type: 'ASC',
        	ref: 'sortSplitButton',
        	handler: this.onSort,
        	menu: new Ext.menu.Menu({
        		items: [
		            {text: PW.t('sort') + ' ' + PW.t("ascending"), type: 'ASC', scope: this, iconCls: 'dvnt-icon-up-straight', handler: this.onSortSwap},
		            {text: PW.t('sort') + ' ' + PW.t("descending"), type: 'DESC',  scope: this, iconCls: 'dvnt-icon-down-straight', handler: this.onSortSwap}
		        ]
		    })
        },
        {
        	xtype: 'combo',
			editable: false,
			forceSelection: true,
			allowBlank: false,
			mode: 'local',
			displayField: 'text',
			valueField: 'field',
			width: 250,
			typeAhead: true,
			triggerAction: 'all',
			value: 'name',
			ref: 'sortFieldCombo',
			store: new Ext.data.ArrayStore({
			    fields: ['text', 'field'],
			    data: [[PW.t('taskName'), 'name'],
			           [PW.t('lastRunDate'), 'lastRun'],
			           [PW.t('className'), 'className'],
			           [PW.t('methodName'), 'methodName']]
			}),
			listeners: {
			    scope: this,
			    select: this.onSortFieldChange
			}
        },
        
        '->',{
        	xtype: 'splitbutton',
        	iconCls: 'dvnt-icon-rotation-right',
        	ref: 'refreshButton',
        	handler: this.onRefreshClick,
        	tooltip: PW.t('refreshInCurrentCategory'),
        	menu: new Ext.menu.Menu({
                items: [
                    {text: PW.t('refreshCategory'), handler: this.onRefreshClick, scope: this},
                    {text: PW.t('refreshAll'), handler: this.onRefreshAllClick, scope: this}
                ]
            }),
        	scope: this
        }]
	}, config);

	Ext.ux.plusmpm.scheduledtasks.TasksFilterToolbar.superclass.constructor.call(this, config);
	
}; // end of Ext.ux.plusmpm.scheduledtasks.TasksFilterToolbar constructor

Ext.extend(Ext.ux.plusmpm.scheduledtasks.TasksFilterToolbar, Ext.Toolbar, {
	
	onSort: function(splitBtn){
		this.swapSortSplitButton(splitBtn.type);
		this.doSort(splitBtn.type);
	},
	
	onSortFieldChange: function(combo){
        this.doSort(this.sortSplitButton.type);
    },
	
	onSortSwap: function(btn){
	    this.doSort(btn.type);
	    this.swapSortSplitButton(btn.type == 'ASC' ? 'DESC' : 'ASC');
	},
	
	doSort: function(type){
	    this.fireEvent('sort', type, this.sortFieldCombo.value);
	},
	
	swapSortSplitButton: function(type){
		switch(type){
			case 'ASC':
				this.sortSplitButton.setText(PW.t('sort') + ' ' + PW.t("ascending"));
				this.sortSplitButton.setIconClass('dvnt-icon-up-straight');
				this.sortSplitButton.type = 'DESC';
				break;
			case 'DESC':
				this.sortSplitButton.setText(PW.t('sort') + ' ' + PW.t("descending"));
				this.sortSplitButton.setIconClass('dvnt-icon-down-straight');
				this.sortSplitButton.type = 'ASC';
				break;
		}
	},
	
	/**
	 * Zdarzenie zmiany tekstu w polu wyszukiwnia
	 * @param textfield
	 * @param event
	 */
	onSearchQueryKeyup: function(textfield, event){
		this.fireEvent('filter',
			textfield.getValue(),
			this.displayStaticIdButton.pressed,
			this.onlyActiveButton.pressed,
			this.onlyProcessingButton.pressed
		);
	},
	
	/**
	 * Zdarzenie przełączenia przycisku "tyko aktywne"
	 * @param button
	 * @param pressed
	 */
	onOnlyActiveToggle: function(button, pressed){
		this.fireEvent('filter',
			this.queryTextfield.getValue(),
			this.displayStaticIdButton.pressed,
			this.onlyActiveButton.pressed,
			this.onlyProcessingButton.pressed
		);
	},

	/**
	 * Zdarzenie przełączenia przycisku "Wyświetlaj statyczne id"
	 * @param button
	 * @param pressed
	 */
	onDisplayStaticIdToggle: function(button, pressed){
		this.fireEvent('filter',
			this.queryTextfield.getValue(),
			this.displayStaticIdButton.pressed,
			this.onlyActiveButton.pressed,
			this.onlyProcessingButton.pressed
		);
	},
	
	/**
	 * Zdarzenie przełączenia przycisku "tyko uruchomion"
	 * @param button
	 * @param pressed
	 */
	onOnlyProcessingToggle: function(button, pressed){
		this.fireEvent('filter',
			this.queryTextfield.getValue(),
			this.displayStaticIdButton.pressed,
			this.onlyActiveButton.pressed,
			this.onlyProcessingButton.pressed
		);
	},
	
	/**
	 * Zdarzenie kliknięcia przycisku Odśwież
	 * @param btn
	 */
	onRefreshClick: function(btn){
		this.fireEvent('refresh', btn);
	},
	
	/**
	 * Zdarzenie kliknięcia przycisku Odśwież wszystko
	 * @param btn
	 */
	onRefreshAllClick: function(btn){
		this.fireEvent('refreshAll', btn);
	},
	
	initComponent : function(){
		Ext.ux.plusmpm.scheduledtasks.TasksFilterToolbar.superclass.initComponent.call(this);
		this.addEvents(
			/**
			 * Zmieniły się kryteria wyszukiwania i potrzebne jest ponowne filtrowanie
			 * @param query szukane wyrażenie
			 * @param activeOnly wskazuje, że szukamy tylko aktywnych zadań
			 */
			'filter',
			/**
			 * Kliknięto przycisk odśwież
			 * @param btn przycisk
			 */
			'refresh',
			/**
			 * Kliknięto przycisk odśwież wszystko
			 * @param btn przycisk
			 */
			'refreshAll',
			/**
			 * Zarzadano sortowanie po danym polu
			 * @param type typ sortowania
			 * @param field pole po którym nalezy posortować
			 */
			'sort'
		);
	}
}); // end of Ext.extend
Ext.reg('st_filtertoolbar', Ext.ux.plusmpm.scheduledtasks.TasksFilterToolbar);