Ext.namespace('PW');

PW.ScheduledTaskUtilsImpl = function (config) {
    PW.ScheduledTaskUtilsImpl.superclass.constructor.call(this, config);
}

Ext.extend(PW.ScheduledTaskUtilsImpl, Object, {

    getMergedListeners: function (listener1, listener2) {
        if (listener1 && listener2) {
            var mergedListener = Ext.apply({}, listener1);

            for (var eventName in listener1) {
                var eventFunc1 = listener1[eventName];
                var eventFunc2 = listener2[eventName];
                if (Ext.isDefined(eventFunc2)) {
                    mergedListener[eventName] = function () {
                        eventFunc1.apply(this, arguments);
                        eventFunc2.apply(this, arguments);
                    }
                }
            }

            return Ext.applyIf(mergedListener, listener2);
        }
        else if (listener1) {
            return Ext.apply({}, listener1);
        }
        else if (listener2) {
            return Ext.apply({}, listener2);
        }

        return undefined;
    },

    initComponent : function() {
        PW.ScheduledTaskUtilsImpl.superclass.initComponent.call(this);
    }

});

PW.ScheduledTaskUtils = new PW.ScheduledTaskUtilsImpl({});
