Ext.namespace('Ext.ux.plusmpm');

/**
 * Dodatkowe parametry konfiguracyjne:
 *
 * config.variableSetConfig.storeId : String
 * config.variableSetConfig.processId : String
 * config.variableSetConfig.activityId : String
 * config.variableSetConfig.variables : Array
 * config.variableSetConfig.targetDivId : String
 *
 * */
Ext.ux.plusmpm.VariableSetGridPanel = function(config) {

	var proxy = new Ext.data.HttpProxy({
	    url : 'com.plusmpm.servlet.VariableSetOperationsServlet.customServlet'
	});

	var store = new Ext.data.JsonStore({
	    proxy       : proxy,
	    storeId     : config.variableSetConfig.storeId,
	    setId		: config.variableSetConfig.setId,
	    autoDestroy : true,
	    batch       : true,
        baseParams  : {
						setId			  : config.variableSetConfig.setId,
						xaction           : Ext.data.Api.actions.read,
                  		processId         : config.variableSetConfig.processId,
                 	    activityId        : config.variableSetConfig.activityId,
                 	 	workflowVariables : config.variableSetConfig.variables
                 	  }
	});

    var view = new Ext.grid.GridView({
        autoFill : true,
        templates: {
            // template komórki - taki sam tylko bez tabindex (nie pozwalamy na focus za pomocą taba)
            cell: new Ext.Template(
                '<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" {cellAttr}>',
                    '<div class="x-grid3-cell-inner x-grid3-col-{id} x-unselectable" unselectable="on" {attr}>{value}</div>',
                '</td>'
            )
        }
    });
	
    config = Ext.apply({
        stateful      : false,
        iconCls       : 'silk-table',
        collapsible   : true,
    	titleCollapse : true,
    	header        : true,
    	height		  : 250,
    	width         : 1000,
        store         : store,
        columns       : [],
        loadMask      : true,
        frame         : true,
        view          : view,
        columnLines   : true,
		tools : [{
	    	id      : 'refresh',
	    	handler : this.onRefresh,
	    	scope   : this,
	    	qtip    : this.refreshTip
			}
		]
    }, config);

	Ext.ux.plusmpm.VariableSetGridPanel.superclass.constructor.call(this, config);
}; // end of Ext.ux.plusmpm.VariableSetGridPanel constructor

Ext.extend(Ext.ux.plusmpm.VariableSetGridPanel, Ext.grid.GridPanel, {

	//public
	errorMsgTitle : PW.t('errorMsgTitle'),

	//public
	unknownErrorText : PW.t('unknownErrorText'),

	//public
	refreshTip : PW.t('refreshTip'),

	//public
	variablesDescription : "",

	//public
	showVariableDescToolTip : false,

	//private
    initComponent : function() {
		Ext.ux.plusmpm.VariableSetGridPanel.superclass.initComponent.call(this);

		this.relayEvents(this.getStore(), ['metachange', 'exception']);
		this.on('metachange', this.onMetachange, this);
		this.on('exception', this.onException, this);
		this.on('expand', this.onCollapseExpand, this);
		this.on('collapse', this.onCollapseExpand, this);
		this.on('afterrender', this.onAfterRender, this);
	},

	//private
	onAfterRender : function() {
		if(this.showVariableDescToolTip)
		{
			var img = "<img style=\"padding-left: 5px\" src=\"pages/images/tooltip.png\"/>";
			
			this.setTitle(this.title ? this.title + img : img);

			var tooltipTarget = this.header.dom.children[2];
			if(tooltipTarget)
			{
				new Ext.ux.plusmpm.DescriptionToolTip({
                    target			: tooltipTarget,
                    html			: this.variablesDescription
                });
			}
		}

		//obejscie dla IE7 - wyswietlanie przycisków po lewej stronie
		if(Ext.isIE7 && this.bbar)
		{
			var toolbar = this.bbar.query("td.x-toolbar-left");
			if(toolbar[0])
				toolbar[0].id = "left";
		}
	},

	//private
	toggleCollapse : function(animate){
		if(this.showVariableDescToolTip)
		{
			var tooltipTarget = this.header.dom.children[2];
			if(!animate.within(tooltipTarget) && tooltipTarget != animate.target)
			{
				Ext.ux.plusmpm.VariableSetEditorGridPanel.superclass.toggleCollapse.call(this, [animate]);
			}
		}
		else
		{
			Ext.ux.plusmpm.VariableSetEditorGridPanel.superclass.toggleCollapse.call(this, [animate]);
		}
	},

	onCollapseExpand : function() {
		this.onRefresh(null, null, this);
		var panel = Ext.getCmp('activity_form_panel');
		if(panel)
		{
			panel.recalculateHeights();
		}
	},


	//private
	onMetachange : function(oStore, oJsonMeta) {
		/*
		wykonuje operacje redefiniowania tylko
		jezeli tabelka jeszcze nie zostala wyswietlona
		*/
		if(this.rendered === false)
		{
			//ustawiam kolumny przekazane w danych jsonData
			if(Ext.isArray(oStore.reader.jsonData.columns) === true)
			{
				var oJsonColumns;
				if(Ext.isFunction(oStore.reader.jsonData.columns.clone) === true)
				{
					oJsonColumns = oStore.reader.jsonData.columns.clone();
        		}
        		else
        		{
        			oJsonColumns = oStore.reader.jsonData.columns;
        		}

				//od 1 bo na 0 pozycji jest id kolumy
				for(var nJCIterator = 1; nJCIterator < oJsonColumns.length; nJCIterator = nJCIterator + 1)
				{
					var oJsonColumn = oJsonColumns[nJCIterator];
					if(oJsonColumn.editor && oJsonColumn.editor.xtype )
					{
						if(oJsonColumn.editor.xtype == "numberfield")
						{
							oJsonColumn.renderer = Ext.util.Format.mpm_numberEU;
						}

						//ustawiam 'renderer' zawijajacy wiersze
						if(oJsonColumn.editor.xtype != "numberfield" && oJsonColumn.editor.xtype != "datefield")
						{
							oJsonColumn.renderer = function(oValue, oMetadata, rRecord, nRowIndex, nColIndex, oStore){
								oMetadata.attr = "style=\"white-space:normal;\"";
								return Ext.util.Format.htmlEncode(oValue);
							};
						}
					}
				}

				oJsonColumns.unshift(new Ext.grid.RowNumberer());

				//ustawiam model kolumn na podstawie otrzymanej konfiguracji
				this.getColumnModel().setConfig(oJsonColumns, true);
			}

			//ustawiam dodatkowe przyciski zdefiniowane w metaData
			try
			{
				if(Ext.isDefined(oJsonMeta.buttons) === true && oJsonMeta.buttons !== null && oJsonMeta.buttons.length > 0)
				{
					Ext.each(oJsonMeta.buttons, function(oButton, nIndex, oAllItems){
						oButton.ref = '../' + oButton.id;
						oButton.handler = eval(oButton.handler);
						this.bottomToolbar.addButton(oButton);
					}, this);
				}
			}
			catch(oError)
			{
				alert("Błąd przy tworzeniu dodatkowych przycisków dla tabelki: " + oError);
			}

            //ustawiam tytul tabelki
            if(Ext.isDefined(oJsonMeta.dt_title) === true)
            {
            	this.setTitle(oJsonMeta.dt_title);
            }

            //tworzymy duzy opis dla wszystkich zmiennych
			if (Ext.isDefined(oJsonMeta.fields) === true){
				if(!this.showVariableDescToolTip)
				{
					var tpl = Ext.DomHelper.createTemplate(
							'<tr class=\"variable-description\"><td class=\"variable-description bold\">{0}</td><td class=\"variable-description\">{1}</td></tr>'
							);

					this.variablesDescription = "<table><tbody>";
					for (var i=0; i < oJsonMeta.fields.length; i++)
					{
						if(oJsonMeta.fields[i].description)
						{
							var desc = oJsonMeta.fields[i].description;
							var variableName = oJsonMeta.fields[i].variableName;
							if(desc != null && desc != "")
							{
								this.showVariableDescToolTip = true;
								this.variablesDescription += tpl.apply([variableName + ':', desc]);
							}
						}
					}
					this.variablesDescription += "</tbody></table>";
				}
			}

            //ustawiam 'zwijalnosc' tabelki
            if(Ext.isDefined(oJsonMeta.dt_collapsible) === true)
            {
            	this.collapsible = oJsonMeta.dt_collapsible;
            	this.titleCollapse = oJsonMeta.dt_collapsible;
            }

            //ustawiam zapisywanie stanu w ciasteczkach
            if(Ext.isDefined(oJsonMeta.dt_stateful) === true)
            {
            	this.stateful = oJsonMeta.dt_stateful;
            }
            else
            {
            	//domyśle wartości
            	this.stateful = true;
            }

           	//odtwarzam stan tabelki - GridPanel/EditorGridPaanel
           	if(this.stateful === true)
           	{
           		//sprawdzam czy tabelka ma zapisany stan w ciasteczku, jezeli tak,
           		//to wylaczam automatyczne dopasowywanie szerokosci kolumn
           		if(Ext.state.Manager.get(this.getStateId(), false) !== false)
           		{
           			this.getView().autoFill = false;

           			//i odczytuje zapisany stan tabelki
           			this.mpm_restoreState();
           		}
           	}

			this.render(this.variableSetConfig.targetDivId);
		}
	},

	//private
	onException : function(oDataProxy, sType, sAction, oOptions, oResponse, mixedArg){
		var sTitle = this.errorMsgTitle;
		var sMsg = this.unknownErrorText;

		if((Ext.isDefined(oResponse.raw) === true) && (Ext.isDefined(oResponse.raw.message) === true))
		{
			sMsg = oResponse.raw.message;
		}
		else if(Ext.isDefined(mixedArg) === true)
		{
			sMsg = mixedArg;
		}

		Ext.Msg.show({
			title: sTitle,
		   	msg: sMsg,
		   	buttons: Ext.MessageBox.OK,
		   	icon: Ext.MessageBox.ERROR
		});

		//na wszelki wypadek odswiezam tabelke, zeby uniknac niespojnosci po wystapieniu bledu
		this.getStore().reload({params:{bNoMetaChange:true}});
	},

    //private
    onRefresh : function(event, toolEl, panel, tc, saveState){
		try
		{
			//zawieszam zdarzenia na czas resetowania
			panel.suspendEvents(false);

			//wlaczam automatyczne dopasowywanie szerokosci kolumn
			panel.getView().forceFit = true;

           	//przerywam edycje kolumn
	        panel.stopEditing();

			//pobieram początkowe definicje kolumn
			var oJsonColumns = panel.getStore().reader.jsonData.columns;

			//resetuje widoczność kolumn
			var nRowNumbererColIndex = panel.getColumnModel().getIndexById( Ext.grid.RowNumberer.prototype.id );
			panel.getColumnModel().moveColumn( nRowNumbererColIndex, 0 );

			oJsonColumns.each(function(oItem, nIndex, nLength){
				var nColumnIndex = panel.getColumnModel().getIndexById( oItem.id );
				panel.getColumnModel().setHidden(nColumnIndex, oItem.hidden === true);
				//+1 bo pierwsza kolumna to numeracja
				panel.getColumnModel().moveColumn( nColumnIndex, (nIndex + 1) );
			});

			//odswiezam widok kolumn
			panel.getView().fitColumns(false);
	        panel.getView().refresh(true);
        }
        finally
        {
        	//wylaczam automatyczne dopasowywanie szerokosci kolumn
        	panel.getView().forceFit = false;

	        if(saveState){
                // usuwam ciasteczko zapisanego stanu
                panel.mpm_clearState();
            }

			//odwieszam zdarzenia po zakonczeniu resetowania
			panel.resumeEvents();
        }
	}
});