Ext.namespace( 'Ext.ux.plusmpm' );

Ext.ux.plusmpm.LocalProxy = function( variables ) {
    var api = {};
    api[Ext.data.Api.actions.create] = true;
    api[Ext.data.Api.actions.read] = true;
    api[Ext.data.Api.actions.update] = true;
    api[Ext.data.Api.actions.destroy] = true;

    this.variables = variables;

    Ext.ux.plusmpm.LocalProxy.superclass.constructor.call( this, {
        api: api
    } );
};

Ext.extend( Ext.ux.plusmpm.LocalProxy, Ext.data.DataProxy, {

    initStore: function( store ) {
        this.store = store;
    },

    doRequest: function( action, rs, params, reader, callback, scope, arg ) {
        var me = this, records, idProperty = reader.meta.idProperty, records;;

        try {
            if ( action === Ext.data.Api.actions.read ) {
                records = reader.readRecords( {
                    records: me.read()
                } );
            }
            else {
                if ( action === Ext.data.Api.actions.destroy ) {
                    records = me.destroy( rs );
                }
                else {
                    records = me.createOrUpdate( rs, reader, action );
                }

                // zapis do formularza aktualnego stanu store'a
                me.save( records, idProperty, rs );
            }

            var response = me.buildResponse( records, action, true );

            // setTimeout: powstają duplikaty rekordów w przypadku dodawania ich
            // przez JS.
            // Ext spodziewa sie, że operacja writera będzie asynchroniczna.
            setTimeout( function() {
                callback.call( scope, response.data, response, true );
            }, 1 );
        }
        catch ( e ) {
            setTimeout( function() {
                me.fireEvent( 'exception', this, 'response', action, arg, {}, e );
                callback.call( scope, null, arg, false );
            }, 1 );
        }
    },

    buildResponse: function( data, action, success ) {
        return new Ext.data.Response( {
            action: action,
            success: success,
            data: data
        } );
    },

    createOrUpdate: function( rs, reader, action ) {
        var records = [], idProperty = reader.meta.idProperty;

        Ext.each( rs, function( record ) {
            var r = this.clone( record.data );
            r[idProperty] = record.id;
            records.push( r );
        }, this );

        return reader.extractData( records, false );
    },

    read: function() {
        // poprostu zwracamy stan tego store'a - ale tylko rekordy które nie są
        // phantomami
        var data = [];
        this.store.each( function( record ) {
            if ( !record.phantom ) {
                data.push( record.data );
            }
        } );
        return data;
    },

    destroy: function( rs ) {
        // na tym etapie rekordy są już usunięte ze store'a. Zapisane są w
        // tabeli "removed"
        return rs;
    },

    commit: function( records ) {
        // każdy z rekordów został zapisany -> nie jest już phantomem
        Ext.each( records, function( rs ) {
            rs.phantom = false;
            rs._phid = rs.id;
        }, this );
    },

    /**
     * Funkcja zapisuje zawartość cache - this.data do formularza
     */
    save: function( modifiedRecords, idProperty ) {

        // zapis całego store'a - ale merg z rekordami zmodyfikowanymi podczas
        // tego żądania - jeżeli rekord nie był teraz modyfikowany, a mimo
        // wszystko oznaczony jest jako "dirty", zapisuje jego "poprzednią"
        // wersję

        var processedRecords = [];
        var values = this.getVariablesValues( modifiedRecords, idProperty, processedRecords ), name, value, variableValues;

        for ( var i = 0; i < this.variables.length; i++ ) {
            name = this.variables[i];
            variableValues = values[name];
            value = '';

            Ext.each( variableValues, function( variableValue, index, length ) {
                value += variableValue;
                if ( index < variableValues.length - 1 ) {
                    value += ';';
                }
            } );

            // zapis na formularz
            Ext.getDom( name ).value = value;
        }

        this.commit( processedRecords );
    },

    getVariablesValues: function( modifiedRecords, idProperty, processedRecords ) {
        var values = {};

        this.store.each( function( record, index, lenght ) {
            var recordData, saveDirty = false, variableValue;

            if ( record.dirty ) {
                recordData = this.getModifiedRecordData( record.id, modifiedRecords, idProperty );
                saveDirty = true;
            }

            // jeżeli phantom, i nie był teraz modyfikowany, pomiń
            if ( record.phantom && recordData == null ) {
                return true;
            }
            else if ( record.phantom ) {
                processedRecords.push( record ); // zostanie później scommitowny
            }

            if ( recordData == null ) {
                // rekord nie jest teraz modyfikowany
                recordData = record.data;
                saveDirty = false;
            }

            // zczytać z rekordu wszystkie data, oprócz idProperty
            for ( variable in recordData ) {
                if ( variable === idProperty ) {
                    continue;
                }

                if ( !Ext.isDefined( values[variable] ) ) {
                    values[variable] = [];
                }

                if ( saveDirty ) {
                    // zapisujemy wartość tylko z data
                    variableValue = recordData[variable];
                }
                else {
                    variableValue = this.getRecordValue( record, variable );
                }

                values[variable].push( variableValue );
            }
        }, this );

        return values;
    },

    getRecordValue: function( record, variable ) {
        if ( record.dirty ) {
            var value = record.modified[variable];
            if ( Ext.isDefined( value ) )
                return value;
        }
        return record.data[variable];
    },

    getModifiedRecordData: function( id, records, idProperty ) {
        for ( var i = 0; i < records.length; i++ ) {
            var record = records[i];
            if ( record[idProperty] === id ) {
                return record;
            }
        }
        return null;
    },

    clone: function( data ) {
        var result = {};
        for ( property in data ) {
            result[property] = data[property];
        }
        return result;
    }
} );
