Ext.namespace('Ext.ux.plusmpm');

Ext.ux.plusmpm.FileViewerAssociatedDocumentsPanel = function(config){
	config = Ext.apply({
		layout: 'anchor',
		frame: false,
		autoHeight: true,
		bodyCssClass: 'fileviewer-information-panel'
	}, config);
	
	Ext.ux.plusmpm.FileViewerAssociatedDocumentsPanel.superclass.constructor.call(this, config);
}; 

Ext.extend(Ext.ux.plusmpm.FileViewerAssociatedDocumentsPanel, Ext.Panel, {

    Viewer: function(text) {
        var windowParams = 'menubar=no,toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=yes,fullscreen=no,channelmode=no,width=' 
        	+ screen.width / 2 + ',height=' + screen.height + ',left=' + screen.width / 2 + ',top=0';
        window.open('', '_blank',windowParams).open(text, '_self', 'viewer').focus();
    },
	
	onRequestSuccessEventHandler: function(jsonObj){
		var me = this;
			Ext.each(jsonObj, function(item){
				if(item.documentsCount > 0){
					me.handleBuildDocClassTables(item);
					me.doLayout();
				}								
			});
		this.getEl().unmask.defer(500, this.getEl());
		this.doLayout();
	},
	
	handleBuildDocClassTables : function(associatedClass){
		var me = this;
		 var url = 'api/documents/' + me.document.fileId + '/associations/classes/'+associatedClass.documentClassId;
	     var table =  this.createDocClassTable(associatedClass, url);
	     me.add(table);

	},
	
	createDocClassTable : function(associatedClass, url){
		
		var me = this;
		var pageSize = parseInt(me.pageSize);
		associatedClass.displayedIndexes.sort(function(a,b){
				return a.ordinalNumber - b.ordinalNumber;
			});	
		var store = me.createLocalStore(associatedClass, url);

		var columnModel = me.generateIndicesColumnModel(associatedClass.displayedIndexes);		
		
	    var pagingToolbar = new Ext.PagingToolbar( {
	        store: store,
	        displayInfo: true,
	        pageSize: pageSize,
	        prependButtons: true
	    } );
	    
		var grid = new Ext.grid.EditorGridPanel({   
			ref: "documentTable_" + associatedClass.documentClassName,
			loadMask: true,
			bbar: pagingToolbar,
			frame: false,
		    store: store,
		    colModel : columnModel,
		    columnLines: true,
		    disableSelection: true,
		    collapsible: true,
			collapsed : true,
			titleCollapse: true,
			title: associatedClass.documentClassName + " (" +associatedClass.documentsCount +")",
		    autoHeight: true,
		    listeners: {
		    	scope: this,		    	
		    	afterrender: this.reloadStoreData,
		    	cellclick: this.onCellClick,
		    	expand: this.forceShimAssociatedWindow,
		    	collapse: this.forceShimAssociatedWindow
		    }
		 });
		return grid;
	},
	
	forceShimAssociatedWindow: function() {
	    if( this.source === 'window' ) {
	        this.ownerCt.setHeight( this.ownerCt.getHeight() );
        }
	},
	
	onCellClick: function(grid, rowIndex, columnIndex, e) {	
		var me = this;
		if(columnIndex == grid.colModel.config.length-3){			
			var record = grid.getStore().getAt(rowIndex);
		    url = "ShowDocumentInformation.do?fileId=" + btoa(record.json.fileId) + "&docClassId=" + record.json.documentClassId;
		    showPopup( url,PW.t('Informacje_o_dokumencie'), 
	                event.pageX, event.pageY, {width: 330});
		}
		else if(columnIndex == grid.colModel.config.length -2){			
		    var record = grid.getStore().getAt(rowIndex);
		    this.Viewer('ShowFile.do?fileName='+btoa(record.json.fileId));
		}
		else if(columnIndex == grid.colModel.config.length -1){			
		    var record = grid.getStore().getAt(rowIndex);
		    if(record.json.associatedDocumentsCount > 0){
		    	showAssociatedDocsPopup(record.json.fileId, record.json.documentClassId,me.pageSize,{width:700} );
		    }		    
		}
	},
	
	reloadStoreData : function(grid){
		var me = this;
		var pageSize = parseInt(me.pageSize);
		grid.store.load({params : {
			start : 0,
			limit : pageSize
		}});
	},

	createLocalStore: function(associatedClass, url){	
	    
		var proxy = new Ext.data.HttpProxy({
			url : url
		});
		var store = new Ext.data.JsonStore({
			storeId : associatedClass.documentClassName + '_store',
			idProperty : 'fileId',
			restful : true,
			proxy : proxy,
			remoteSort : true,
		    fields : this.generateStoreFields(associatedClass.displayedIndexes),
	        totalProperty: 'total', 
	        root : 'data',
	        sortInfo : {
	        	field : 'fileId',
	        	direction : 'ASC'
	        }
		  });
		return store;
	},
	
	generateStoreFields: function(displayedIndexes)
	{
		var fields = new Array();
		for(var i=0; i<displayedIndexes.length; i++)
		{
			
			fields.push(displayedIndexes[i].indexId+"");
		}
		fields.push('fileId');
		fields.push('documentClassId');
		fields.push('associatedDocumentsCount');
		return fields;
	},
		
	generateIndicesColumnModel: function(indices){
		var count = indices.length;
		var columns = new Array();

		for(var i=0; i<count; i++)
		{
			var column = {header: indices[i].indexName, dataIndex: i, sortable:true, minWidth: 50, renderer: this.indexesColumnRenderer({indexId : indices[i].indexId}), getEditor: function(record) {console.log("in get editorr function"); console.log(record);}};
			columns.push(column);
		}
		columns.push(
				{
					header: PW.t('Inf'), 
					dataIndex: count, 
					width: 70, 
					fixed : true,
					css:'text-align:center;',
					renderer: function( value, metaData, record, rowIndex, colIndex, store, view ) {
							return '<div class="dvnt-icon-info-circle dvnt-blue-icon" style="cursor:pointer;width:16px;height:16px;"></div>';
					}
				});
		columns.push(
				{
					header: PW.t('Pokaz'), 
					fixed : true,
					dataIndex: count+1, 
					width: 70,
					css:'text-align:center;',
					renderer: function( value, metaData, record, rowIndex, colIndex, store, view ) {
						return '<div class="dvnt-icon-show dvnt-gray-icon" style="cursor:pointer;width:16px;height:16px;"></div>';
					}
				});
		columns.push(
				{
					header: PW.t('Powiazania'), 
					dataIndex: count+2,
					fixed : true,
					width: 70,
					css:'text-align:center;',
					renderer: function( value, metaData, record, rowIndex, colIndex, store, view ) {

						if(record.data.associatedDocumentsCount > 0){
							return '<div style="cursor:pointer;display:flex;"><div class="dvnt-icon-copy dvnt-gray-icon" style="cursor:pointer;width:16px;height:16px;"></div>(' +record.data.associatedDocumentsCount +')</div>';
						}
						else
						{
							return '<div style="display:flex;"><div class="dvnt-icon-copy dvnt-gray-icon" style="cursor:pointer;width:16px;height:16px;opacity:0.5;"></div>(' +record.data.associatedDocumentsCount +')</div>';
						}
						
					}
				});
		var columnModel = new Ext.grid.ColumnModel(columns);
		return columnModel;
	},
		
	indexesColumnRenderer : function(params){
		return function( value, metaData, record, rowIndex, colIndex, store, view ) {
			var result = '';
			record.json.indexes.forEach(function(index){					
				if(index.id == params.indexId){
					if(index.type == 'DATETIME'){
						if(index.value){
							result = Ext.util.Format.date(new Date(index.value), 'Y-m-d H:m:s');
						}						
					}
					else if(index.type == 'BOOLEAN'){
						result = index.value ? PW.t('trueText') : PW.t('falseText');
					}
					else {
						result =  index.value;
					}					
				}				
			});
			return result;
		}
	},
	
	onExpandEventHandler : function() {
		this.getEl().mask(Ext.LoadMask.prototype.msg, 'x-mask-loading');
		var me = this;

		Ext.Ajax.request({
			   url: 'api/documents/' + me.document.fileId + '/associations/',
			   method: 'GET',
			   scope: this,
			   success: function(response, opts) {
			     this.onRequestSuccessEventHandler(Ext.decode(response.responseText));
			   }
			});
		this.un("beforeexpand", this.onExpandEventHandler, this);
	},	
	
	initComponent: function(){
		Ext.ux.plusmpm.FileViewerAssociatedDocumentsPanel.superclass.initComponent.call(this);

		if(this.initialConfig.source == 'window')
		{
			this.on("afterrender", this.onExpandEventHandler, this);
		}
		else
		{
			this.on("afterrender", function(){this.collapse(false)}, this);
			this.on("beforeexpand", this.onExpandEventHandler, this);
		}

	}
});

Ext.ux.plusmpm.FileViewerAssociatedDocumentsWindow = function(config){
	
	var associatedDocumentsPanel = new Ext.ux.plusmpm.FileViewerAssociatedDocumentsPanel({
		ref: 'associatedDocumentsParentPanel_' + config.document.fileId,
		document: config.document,
		source : 'window',
		autoScroll: true,
		pageSize : config.pageSize
	});
	config = Ext.apply({
	    autoScroll : true,
		width: 500,
		autoHeight: true,
		boxMaxHeight : 500,
		shadow: false,
	    modal: true,
		layout: 'fit',
		items: [associatedDocumentsPanel],
		y: window.fileViewer ? 10 : undefined
	}, config);
	Ext.ux.plusmpm.FileViewerAssociatedDocumentsWindow.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.FileViewerAssociatedDocumentsWindow, Ext.Window, {
	
});

function showAssociatedDocsPopup( fileId, docClassId, pageSize,config, event ) {
    var doc = {fileId : fileId, docClassId : docClassId };
    
    config = Ext.apply( {
        title: PW.t('Dokumenty_powiazane'),
        document : doc,
        pageSize : pageSize
    }, config );

    var associatedDocuments = new Ext.ux.plusmpm.FileViewerAssociatedDocumentsWindow( config );
    associatedDocuments.show();
    
    return associatedDocuments;
}
