(function(Ext) {

	Ext.define('Suncode.datasourcemanager.store.DataSourceStore', {
		extend: 'Ext.data.TreeStore',
        model: 'Suncode.datasourcemanager.model.DataSourceTreeNode',
        root: {
        	expanded: true
        },
        proxy: {
			type: 'ajax',
			url: Suncode.getAbsolutePath('/api/datasources/tree'),
			reader: {
				type: 'json'
			}
		},
        sorters: [
			{
				property: 'order',
				direction: 'ASC'
			}, {
				property: 'name',
				direction: 'ASC'
			}
		],
		listeners:{
			load: function (store,node, records, successful, eOpts){
				const rootNode = node.raw;
				rootNode.children = records.map(record => record.raw);
				store.originalRoot = rootNode;
			}
		}
    });

})(Ext4);