(function(Ext) {
	Ext.ux.suncode.TableCustomField = function(config) {
		var items = new Array();
		var fields = config.fields;

		if (!Ext.isEmpty(fields)) {
			Ext.each(fields, function(field, index, allFields) {
				field = Ext.apply(field, {
					table : this
				});

				items.push({
					xtype : 'panel',
					frame : false,
					border : false,
					labelAlign : 'top',
					layout : 'form',
					columnWidth : 1 / fields.length,
					items : [ field ]
				});
			}, this);
		}

		config = Ext.apply({
			frame : false,
			border : false,
			layout : 'column',
			isTableField : true,
			items : items
		}, config);

		Ext.ux.suncode.TableCustomField.superclass.constructor.call(this,
				config);
	};

	Ext.define('Ext.ux.suncode.TableCustomField',
			{
				extends: 'Ext.panel.Panel',
		
				initComponent : function() {
					Ext.ux.suncode.TableCustomField.superclass.initComponent
							.call(this);
				},
				getFieldId : function() {
					return this.initialConfig.tableId;
				},
				addFields : function(position) {
					this.items.each(function(panel) {
						var array = panel.items.first();
						array.executeAddField(position);
					});
				},
				removeFields : function(position) {
					this.items.each(function(panel) {
						var array = panel.items.first();
						array.executeRemoveField(position);
					});
				},
				getParametersValues : function() {
					var values = new Object();

					this.items.each(function(panel) {
						var array = panel.items.first();

						if (array.isParameterField) {
							var id = array.getFieldId();
							var value = array.getFieldValue();

							values[id] = value;
						}
					});

					return values;
				},
				isFieldValid : function() {
					var valid = true;

					this.items.each(function(panel) {
						var array = panel.items.first();
						if (!array.isFieldValid()) {
							showWarn(getTranslation('Niepoprawna wartość pola')
									+ ': ' + array.getFieldName());
							valid = false;
							return false;
						}
					});

					return valid;
				},
				hasField : function(fieldId) {
					var has = false;

					this.items.each(function(panel) {
						var array = panel.items.first();

						if (array.isParameterField
								&& array.getFieldId() === fieldId) {
							has = true;
							return false;
						}
					});

					return has;
				},
				getField : function(fieldId) {
					var field = null;

					this.items.each(function(panel) {
						var array = panel.items.first();

						if (array.isParameterField
								&& array.getFieldId() === fieldId) {
							field = array;
							return false;
						}
					});

					return field;
				},
				getArraySize : function() {
					var panel = this.items.first();
					var array = panel.items.first();

					return array.items.getCount();
				},
				focusField : function(delay, reverse) {
					var panel = reverse ? this.items.last() : this.items
							.first();
					var array = panel.items.first();
					array.focusField(delay, reverse);
				},
				isReadOnly : function() {
					var fields = this.initialConfig.fields;
					var readOnly = true;

					if (!Ext.isEmpty(fields)) {
						Ext.each(fields, function(field, index, allFields) {
							var customFieldDef = field.customFieldDef;

							if (!customFieldDef.readOnly) {
								readOnly = false;
								return false;
							}
						});
					}

					return readOnly;
				}
			});

})(Ext4);