(function (Ext) {

    /**
     * Data source registry with scripts to build params  
     * 
     * Registration should look like:
     *
     * 	PW.DataSources.registry('data-source-1', {
     * 		buildParams: function(form){
     * 			...
     * 		}
     * 	});
     *
     * @class PW.DataSources
     * @static
     */
    Ext.define('PW.DataSources', {
        singleton: true,

        dataSourcesBuilders: new Ext.util.MixedCollection(),

        register: function (dataSourceId, builder) {
        	this.dataSourcesBuilders.add(dataSourceId, builder);
        },
        
        contains: function(dataSourceId){
        	return this.dataSourcesBuilders.containsKey(dataSourceId);
        },
        
        get: function(dataSourceId){
        	return this.dataSourcesBuilders.get(dataSourceId);
        }
    });
}(this.Ext4));
