/**
 * Gadget API
 */
Suncode = window.parent.Suncode;
Gadget = (function (window) {
  // zmienne prywatne
  var gadgetCmp;

  return {
    bind: function (config) {
      gadgetCmp = window.parent.Ext.getCmp('gadget-portlet-' + config.id);
      if (!gadgetCmp) {
        throw new Error('Gadget with specified id could not be found');
      }

      gadgetCmp.sync(config.gadget);
    },

    refreshLayout: function () {
      gadgetCmp.dashboard.getLayoutManager().recalculatePositions();
    },

    /**
     * Sprawdza, czy zalogowany użytkownik jest właścicielem dashboardu
     *
     * @return {@code true}, jeżeli użytkownik jest właścicielem dashboardu
     */
    isOwner: function () {
      return gadgetCmp.dashboard.isOwner;
    },

    /**
     * Zwraca identyfikator tego gadżetu
     *
     * @return identyfikator gadżetu
     */
    getId: function () {
      return gadgetCmp.gadget.id;
    },

    /**
     * Zwraca klucz tego gadżetu
     *
     * @return klucz gadżetu
     */
    getKey: function () {
      return gadgetCmp.gadget.key;
    },

    /**
     * Zwraca aktualny tytuł gadżetu
     *
     * @return tytuł gadżetu
     */
    getTitle: function () {
      return gadgetCmp.title;
    },

    /**
     * Zmienia tytuł gadżetu na podany tekst
     *
     * @param newTitle nowy tytuł gadżetu
     */
    setTitle: function (newTitle) {
      gadgetCmp.setTitle(newTitle);
    },

    refreshSize: function () {
      if (this.hasAutoHeight()) {
        this.enableAutoHeight();
      }
    },

    hasAutoHeight: function () {
      return gadgetCmp.autoHeight || gadgetCmp.aHeight;
    },

    enableAutoHeight: function () {
      gadgetCmp.setAutoHeight();
      this.refreshLayout();
    },

    getHeight: function () {
      return gadgetCmp.getHeight();
    },

    setHeight: function (height) {
      // TODO: obiekt Gadget powinien mieć takie metody...
      gadgetCmp.autoHeight = false;
      gadgetCmp.setHeight(height);
      gadgetCmp.settingsMenu.find('itemId', 'autoheight')[0].setChecked(false);
      this.refreshLayout();
    },

    getWidth: function () {
      return gadgetCmp.getWidth();
    },

    /**
     * Pokazuje konfigurację gadżetu.
     * Opcjonalnie wymusza na użytkowniku poprawne uzupełnienie formularza.
     *
     * @param force jeżeli true, przycisk "Anuluj" formularza nie będzie widoczny
     */
    showConfiguration: function (force) {
      gadgetCmp.showPropertiesForm(force === true);
    },

    /**
     * Odświeża gadżet. Możemy podać interval, mówiący kiedy podany gadżet ma zostać odświeżony.
     *
     * @param timeout czas w milisekundach, za ile gadżet ma zostać odświeżony
     */
    refresh: function (timeout) {
      if (timeout == -1) {
        return;
      }

      if (timeout > 0) {
        setTimeout(function () {
          gadgetCmp.loadGadgetContent();
        }, timeout * 60 * 1000);
      } else {
        gadgetCmp.loadGadgetContent();
      }
    },

    /**
     * Pobiera właściwości gadżetu
     *
     * @return właściwości gadżetu
     *     {
     *         'prop1': {
     *             name: 'prop1',
     *             type: 'text',
     *             value: 'val'
     *         },
     *         ...
     *     }
     */
    getProperties: function () {
      return gadgetCmp.gadget.properties;
    },

    /**
     * Pobiera właściwość gadżetu o podanej nazwie
     *
     * @return właściwość gadżetu o podanej nazwie
     *
     *     {
     *         name: 'prop1',
     *         type: 'text',
     *         value: 'val'
     *     }
     */
    getProperty: function (name) {
      return gadgetCmp.gadget.properties[name];
    },

    /**
     * Rejestruje funkcję na zdarzeniu zmiany rozmiaru
     *
     * @param fn funkcja, która ma zostać wywołana przy zdarzeniu
     * @param scope
     */
    onResize: function (fn, scope) {
      gadgetCmp.on('bodyresize', fn, scope, {
        removeOnRefresh: true,
      });
    },

    /**
     * Rejestruje funkcję na zdarzeniu rozwijania
     *
     * @param fn funkcja, która ma zostać wywołana przy zdarzeniu
     * @param scope
     */
    onExpand: function (fn, scope) {
      gadgetCmp.on('expand', fn, scope, {
        removeOnRefresh: true,
      });
    },

    /**
     * Rejestruje funkcję na zdarzeniu minimalizacji
     *
     * @param fn funkcja, która ma zostać wywołana przy zdarzeniu
     * @param scope
     */
    onCollapse: function (fn, scope) {
      gadgetCmp.on('collapse', fn, scope, {
        removeOnRefresh: true,
      });
    },

    /**
     * Sprawdza, czy dashboard jest w trybie edycji
     *
     * @return {@code true}, jeżeli dashboard jest w trybie edycji
     */
    isEditMode: function () {
      return gadgetCmp.dashboard.isEditMode;
    },

    /**
     *  Pobiera layout gadżetu
     * @returns layout gadżetu
     */
    getLayout: function () {
      return gadgetCmp.gadget.layout;
    },

    /**
     * Ustawia szerokość i wysokość gadżetu na podaną ilość segmentów siatki
     * @param netWidth ilość segemntów siatki
     */
    setWidthAndHeightByNetSize: function (netWidth) {
      gadgetCmp.setWidthAndHeightByNetSize(netWidth);
    },

    /**
     * Zapisuje layout dashboardu
     * @param exitEditMode czy po zapisie wyjść z trybu edycji
     */
    saveLayout: function (exitEditMode) {
      gadgetCmp.dashboard.getLayoutManager().saveLayout(exitEditMode);
    },
  };
})(window);
