    Ext.namespace('Ext.suncode.dashboard');

    var messages = Suncode.context('dashboard').messages;

    var FIX_X = window.localStorage.hasOwnProperty('dockMenu') && window.localStorage.getItem('dockMenu') === 'true' ? 280 : 68;
    var INITIAL_Y_POSITION = 105;
    var LAYOUT_MARGIN_Y = 20;
    var HEIGHT_INCREMENT = 10;
    var HEADER_HEIGHT = 40;

    /**
     * Odpowiedzialny za przechowywanie layoutu, zapisywanie zmian etc.
     */
    Ext.suncode.dashboard.LayoutManager = Ext.extend(Ext.util.Observable, {
        /**
         * Definicje gadżetów -> klucz to ich ID
         */
        gadgets: undefined,

        gadgetArea: undefined,

        /**
         * Właściciel layoutu, potrzebny do budowania żądań zmiany i sprawdzenia,
         * czy można go edytować
         */
        owner: undefined,

        constructor: function (config) {
            this.owner = config.owner;
            this.gadgets = new Ext.util.MixedCollection();

            Ext.each(
                config.gadgets,
                function (gadget) {
                    this.gadgets.add(gadget.id, gadget);
                },
                this
            );

            this.gadgets.sort('ASC', function (a, b) {
                if (a.layout.order < b.layout.order) return -1;
                if (a.layout.order > b.layout.order) return 1;
                return 0;
            });

            Ext.suncode.dashboard.LayoutManager.superclass.constructor.call(this);
        },

        setGadgetArea: function (gadgetArea) {
            this.gadgetArea = gadgetArea;
        },

        saveLayout: function (exitEditMode) {
            var gadgets = this.getGadgets();
            gadgetsConfig = new Array();

            for (var i = 0; i < gadgets.length; i++) {
                gadgets[i].setProperPosition();
                gadgets[i].setProperWidth();
                gadgets[i].setProperHeight();
                gadgets[i].setOrder(i);

                var gadgetHeight = gadgets[i].gadget.layout.height,
                    borderHidden = gadgets[i].gadget.borderHidden;

                if (borderHidden && gadgetHeight === -1) {
                    gadgetHeight = gadgets[i].getHeight() - HEADER_HEIGHT;
                } else if (borderHidden) {
                    gadgetHeight -= HEADER_HEIGHT;
                }

                gadgetsConfig.push({
                    gadgetId: gadgets[i].gadget.id,
                    positionX: gadgets[i].gadget.layout.positionX,
                    width: gadgets[i].gadget.layout.width,
                    height: gadgetHeight,
                    order: gadgets[i].gadget.layout.order,
                    collapsed: gadgets[i].collapsed,
                });
            }
            this.save(gadgetsConfig, exitEditMode);
        },

        save: function (gadgets, exitEditMode) {
            Ext.Ajax.request({
                url: 'api/dashboards/' + Ext.suncode.dashboard.Dashboard.instance.id + '/save',
                method: 'PUT',
                jsonData: gadgets,
                scope: this,
                success: function (response) {
                    if (exitEditMode) {
                        var editButton = this.gadgetArea.ownerCt.find('itemId', 'toolbar')[0].find('id', 'edit')[0];
                        editButton.el.dom.click();
                    }
                },
                failure: function () {
                    Ext.Msg.show({
                        title: messages('gadget.error.label'),
                        msg: messages('gadget.error.text') + '.',
                        buttons: Ext.Msg.OK,
                        icon: Ext.MessageBox.ERROR,
                    });
                },
            });
        },

        /**
         * Dodaje nowy gadżet do layoutu. Wysyłane jest żądanie do serwera dodania
         * gadżetu.
         */
        addGadget: function (gadget) {
            var dashboard = Ext.suncode.dashboard.Dashboard.instance.id;

            Ext.Ajax.request({
                url: 'api/dashboards/' + dashboard + '/gadgets',
                method: 'POST',
                params: {
                    gadget: gadget.data.key,
                    order: this.gadgetArea.items.length,
                },
                scope: this,
                success: function (response) {
                    var gadgetConfig = Ext.util.JSON.decode(response.responseText);
                    var addedGadget = this.gadgetArea.add(new Ext.suncode.dashboard.Gadget(gadgetConfig));
                    this.gadgetArea.doLayout();
                    this.recalculatePositions();
                    this.setPositionY(addedGadget);
                    addedGadget.showPropertiesForm(true);
                    this.setDashboardHeight();
                },
            });
        },

        removeGadget: function (gadgetId, gadgetPanel) {
            Ext.Msg.show({
                title: messages('gadget.delete.label'),
                msg: messages('gadget.delete.text'),
                buttons: Ext.Msg.YESNO,
                fn: function (button) {
                    if (button === 'yes') {
                        gadgetPanel.hidePropertiesForm(false);
                        this.remove(gadgetId, gadgetPanel);
                        if (gadgetPanel.gadget.borderHidden) {
                            var dashboard = Ext.suncode.dashboard.Dashboard.instance;
                            dashboard.setAddGadgetAndSaveButtonDisabled(false);
                        }
                    }
                },
                scope: this,
                icon: Ext.MessageBox.QUESTION,
            });
        },

        remove: function (gadgetId, gadgetPanel) {
            var dashboard = Ext.suncode.dashboard.Dashboard.instance.id;

            Ext.Ajax.request({
                url: 'api/dashboards/' + dashboard + '/gadgets/' + gadgetId,
                method: 'DELETE',
                scope: this,
                success: function (response) {
                    gadgetPanel.destroy();
                    this.recalculatePositions();
                },
            });
        },

        getGadget: function (id) {
            return this.gadgets.get(id);
        },

        loadGadgets: function () {
            var addedGadget;
            this.gadgets.each(function (gadget, gadgetId) {
                addedGadget = this.gadgetArea.add(new Ext.suncode.dashboard.Gadget(gadget));
                this.gadgetArea.doLayout();
                this.setPositionY(addedGadget);
            }, this);
            this.setDashboardHeight();
        },

        /**
         * Funkcja ustawia wysokoś dashboardu w zależności od położenia gadżetów.
         */
        setDashboardHeight: function () {
            var lowestPosition = this.gadgetArea.minHeight,
                itemPositionY;

            this.gadgetArea.items.each(function (item) {
                if (item.isVisible() === true) {
                    itemPositionY = item.getPosition()[1] - this.gadgetArea.getPosition()[1] + item.getHeight();

                    if (itemPositionY > lowestPosition) {
                        lowestPosition = itemPositionY;
                    }
                }
            }, this);
            this.gadgetArea.setHeight(lowestPosition + 10);
        },

        /**
         * Funkcja nie pozwalająca, aby gadżet wyszedł poza obręb dashboardu w poziomie.
         */
        getDraggedX: function (ghost) {
            var properX = ghost.getLeft(true) - this.gadgetArea.getPosition()[0],
                dashboardWidth = this.gadgetArea.getWidth(),
                targetWidth = ghost.getWidth();

            if (properX + targetWidth > dashboardWidth) {
                properX = dashboardWidth - targetWidth;
            }

            if (properX < 0) {
                properX = 0;
            }

            return properX;
        },

        /**
         * Funkcja dba, aby gadżet był wyrównany do siatki.
         */
        alignmentToNet: function (properX, gadget, fixX) {
            var net = this.gadgetArea.net,
                div = Math.floor((properX - (fixX ? FIX_X : 0)) / net),
                mod = (properX % net) - FIX_X;

            if (mod > net / 2) {
                div = div + 1;
            }
            gadget.xProxy = Math.floor(div * net + this.gadgetArea.getPosition()[0]);
            gadget.yProxy = this.gadgetArea.getPosition()[1];
        },

        recalculatePositions: function () {
            var gadgets = this.getGadgets();
            for (var i = 1; i < gadgets.length; i++) {
                gadgets[i].setPosition(gadgets[i].x, gadgets[i - 1].y + gadgets[i - 1].getHeight() + LAYOUT_MARGIN_Y);
            }
            for (var i = 0; i < gadgets.length; i++) {
                this.setPositionY(gadgets[i]);
            }
            this.setDashboardHeight();
        },

        setSiblingsPosition: function (siblings, comp) {
            siblings.sort(this.compare);
            if (siblings.length > 0) {
                siblings[0].setPosition(siblings[0].x, comp.y + comp.getHeight() + LAYOUT_MARGIN_Y);
            }
            for (var i = 1; i < siblings.length; i++) {
                siblings[i].setPosition(siblings[i].x, siblings[i - 1].y + siblings[i - 1].getHeight() + LAYOUT_MARGIN_Y);
            }

            for (var i = 0; i < siblings.length; i++) {
                this.setPositionY(siblings[i]);
            }
        },

        /**
         * Funkcja zwraca listę z gadżetami, oprócz gadżetu podanego jako parametr.
         * Lista jest posortowana od gażetów znajdujących się na samej górze aż po te na samym dole.
         */
        getSiblings: function (gadget) {
            var siblings = new Array();

            this.gadgetArea.items.each(function (item) {
                if (item !== gadget && item.itemId != 'emptyComponent') {
                    siblings.push(item);
                }
            }, this);

            siblings.sort(this.compare);

            return siblings;
        },

        getSiblingsAbove: function (ghost, gadget) {
            var siblingsAbove = new Array();

            this.gadgetArea.items.each(function (item) {
                if (item !== gadget && item.itemId != 'emptyComponent') {
                    if (item.getPosition()[1] + item.getHeight() / 2 < ghost.getTop(true)) {
                        siblingsAbove.push(item);
                    }
                }
            });

            siblingsAbove.sort(this.compare);

            return siblingsAbove;
        },

        getGadgets: function () {
            var gadgets = new Array();

            this.gadgetArea.items.each(function (item) {
                gadgets.push(item);
            });

            gadgets.sort(this.compare);

            return gadgets;
        },

        /**
         * Funkcja porównująca 2 gadżety w celu posortowania. Sortujemy od gadżetów znajdujących się najwyżej od lewej strony.
         */
        compare: function (a, b) {
            if (a.y < b.y) return -1;
            if (a.y > b.y) return 1;
            if (a.y == b.y) {
                if (a.x < b.x) return -1;
                if (a.x > b.x) return 1;
            }
            return 0;
        },

        /**
         * Jeżeli przenoszony gadżet ma cień, to musimy też zmienic jego położenie.
         */
        keepShadow: function (ghost) {
            var s = this.getEl().shadow;
            if (s) {
                s.realign(ghost.getLeft(true), ghost.getTop(true), this.getWidth(), this.getHeight());
            }
        },

        activateDD: function (gadget) {
            gadget.dd.unlock();
            gadget.removeClass('custom-cursor');
        },

        deactivateDD: function (gadget) {
            gadget.dd.lock();
            gadget.addClass('custom-cursor');
        },

        activateResizer: function (gadget) {
            var net = this.gadgetArea.net;

            gadget.resizer = new Ext.Resizable(gadget.el, {
                handles: 's e se',
                //dla pojedyńczych kafelków linie do zmiany rozmiaru są widoczne od razu po wejściu w tryb edycji MODPLWRKFL-484
                pinned: gadget.gadget.borderHidden,
                widthIncrement: net,
                heightIncrement: HEIGHT_INCREMENT,
                resizeElement: function () {
                    var box = this.proxy.getBox();
                    gadget.updateBox(box);
                    if (gadget.layout) {
                        gadget.doLayout();
                    }
                    return box;
                },
            });
            gadget.resizer.on('beforeresize', gadget.beforeResizer, gadget);
            gadget.resizer.on('resize', gadget.onResizer, gadget);
        },

        deactivateResizer: function (gadget) {
            gadget.resizer.destroy();
        },

        hideSiblings: function (gadget) {
            var siblings = this.getSiblings(gadget);
            for (var i = 0; i < siblings.length; i++) {
                siblings[i].positionX = siblings[i].getPosition()[0];
                siblings[i].positionY = siblings[i].getPosition()[1];
                siblings[i].setVisible(false);
            }
        },

        showSiblings: function (gadget) {
            var siblings = this.getSiblings(gadget);
            for (var i = 0; i < siblings.length; i++) {
                siblings[i].setVisible(true);
                siblings[i].setPosition(siblings[i].positionX, siblings[i].positionY);
            }
        },

        /**
         * Funkcja ustawiająca przeciągany gadżet.
         */
        setDraggedY: function (target, ghost) {
            var panelX1 = target.xProxy,
                panelY1 = target.yProxy,
                panelX2 = panelX1 + ghost.getWidth(),
                panelY2 = panelY1 + ghost.getHeight() + 10;
            var test = false;
            while (!test) {
                test = true;
                isAllowed = true;
                var siblingsAbove = target.dashboard.getLayoutManager().getSiblingsAbove(ghost, target);
                for (var i = 0; i < siblingsAbove.length; i++) {
                    var item = siblingsAbove[i],
                        itemPosition = item.getPosition(),
                        itemX1 = itemPosition[0],
                        itemY1 = itemPosition[1],
                        itemX2 = itemX1 + item.getWidth(),
                        itemY2 = itemY1 + item.getHeight();

                    if (
                        panelX1 >= itemX1 &&
                        panelX1 <= itemX2 &&
                        ((panelY1 >= itemY1 && panelY1 <= itemY2) || (panelY2 >= itemY1 && panelY2 <= itemY2))
                    ) {
                        target.yProxy = itemY2 + 1;
                        panelY1 = target.yProxy;
                        panelY2 = panelY1 + ghost.getHeight() + 10;
                        test = false;
                    } else {
                        if (
                            panelX2 >= itemX1 &&
                            panelX2 <= itemX2 &&
                            ((panelY1 >= itemY1 && panelY1 <= itemY2) || (panelY2 >= itemY1 && panelY2 <= itemY2))
                        ) {
                            target.yProxy = itemY2 + 1;
                            panelY1 = target.yProxy;
                            panelY2 = panelY1 + ghost.getHeight() + 10;
                            test = false;
                        } else {
                            if (
                                panelX1 >= itemX1 &&
                                panelX1 <= itemX2 &&
                                panelX2 >= itemX1 &&
                                panelX2 <= itemX2 &&
                                itemY1 >= panelY1 &&
                                itemY1 <= panelY2 &&
                                itemY2 >= panelY1 &&
                                itemY2 <= panelY2
                            ) {
                                target.yProxy = itemY2 + 1;
                                panelY1 = target.yProxy;
                                panelY2 = panelY1 + ghost.getHeight() + 10;
                                test = false;
                            } else {
                                if (
                                    itemX1 >= panelX1 &&
                                    itemX1 <= panelX2 &&
                                    ((itemY1 >= panelY1 && itemY1 <= panelY2) || (itemY2 >= panelY1 && itemY2 <= panelY2))
                                ) {
                                    target.yProxy = itemY2 + 1;
                                    panelY1 = target.yProxy;
                                    panelY2 = panelY1 + ghost.getHeight() + 10;
                                    test = false;
                                } else {
                                    if (
                                        itemX2 >= panelX1 &&
                                        itemX2 <= panelX2 &&
                                        ((itemY1 >= panelY1 && itemY1 <= panelY2) || (itemY2 >= panelY1 && itemY2 <= panelY2))
                                    ) {
                                        target.yProxy = itemY2 + 1;
                                        panelY1 = target.yProxy;
                                        panelY2 = panelY1 + ghost.getHeight() + 10;
                                        test = false;
                                    } else {
                                        if (
                                            itemX1 >= panelX1 &&
                                            itemX1 <= panelX2 &&
                                            itemX2 >= panelX1 &&
                                            itemX2 <= panelX2 &&
                                            panelY1 >= itemY1 &&
                                            panelY1 <= itemY2 &&
                                            panelY2 >= itemY1 &&
                                            panelY2 <= itemY2
                                        ) {
                                            target.yProxy = itemY2 + 1;
                                            panelY1 = target.yProxy;
                                            panelY2 = panelY1 + ghost.getHeight() + 10;
                                            test = false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        },

        setPositionY: function (target) {
            var panelX1 = target.getPosition()[0],
                panelY1 = target.ownerCt.getPosition()[1],
                panelX2 = panelX1 + target.getWidth(),
                panelY2 = panelY1 + target.getHeight(),
                changedPosition = true;

            while (changedPosition) {
                changedPosition = false;
                target.ownerCt.items.each(function (item) {
                    if (item !== target) {
                        var itemPosition = item.getPosition(),
                            itemX1 = itemPosition[0],
                            itemY1 = itemPosition[1],
                            itemX2 = itemX1 + item.getWidth(),
                            itemY2 = itemY1 + item.getHeight();

                        if (
                            panelX1 >= itemX1 &&
                            panelX1 <= itemX2 &&
                            ((panelY1 >= itemY1 && panelY1 <= itemY2) || (panelY2 >= itemY1 && panelY2 <= itemY2))
                        ) {
                            panelY1 = itemY2 + 1;
                            panelY2 = panelY1 + target.getHeight();
                            changedPosition = true;
                        } else {
                            if (
                                panelX2 >= itemX1 &&
                                panelX2 <= itemX2 &&
                                ((panelY1 >= itemY1 && panelY1 <= itemY2) || (panelY2 >= itemY1 && panelY2 <= itemY2))
                            ) {
                                panelY1 = itemY2 + 1;
                                panelY2 = panelY1 + target.getHeight();
                                changedPosition = true;
                            } else {
                                if (
                                    panelX1 >= itemX1 &&
                                    panelX1 <= itemX2 &&
                                    panelX2 >= itemX1 &&
                                    panelX2 <= itemX2 &&
                                    itemY1 >= panelY1 &&
                                    itemY1 <= panelY2 &&
                                    itemY2 >= panelY1 &&
                                    itemY2 <= panelY2
                                ) {
                                    panelY1 = itemY2 + 1;
                                    panelY2 = panelY1 + target.getHeight();
                                    changedPosition = true;
                                } else {
                                    if (
                                        itemX1 >= panelX1 &&
                                        itemX1 <= panelX2 &&
                                        ((itemY1 >= panelY1 && itemY1 <= panelY2) || (itemY2 >= panelY1 && itemY2 <= panelY2))
                                    ) {
                                        panelY1 = itemY2 + 1;
                                        panelY2 = panelY1 + target.getHeight();
                                        changedPosition = true;
                                    } else {
                                        if (
                                            itemX2 >= panelX1 &&
                                            itemX2 <= panelX2 &&
                                            ((itemY1 >= panelY1 && itemY1 <= panelY2) || (itemY2 >= panelY1 && itemY2 <= panelY2))
                                        ) {
                                            panelY1 = itemY2 + 1;
                                            panelY2 = panelY1 + target.getHeight();
                                            changedPosition = true;
                                        } else {
                                            if (
                                                itemX1 >= panelX1 &&
                                                itemX1 <= panelX2 &&
                                                itemX2 >= panelX1 &&
                                                itemX2 <= panelX2 &&
                                                panelY1 >= itemY1 &&
                                                panelY1 <= itemY2 &&
                                                panelY2 >= itemY1 &&
                                                panelY2 <= itemY2
                                            ) {
                                                panelY1 = itemY2 + 1;
                                                panelY2 = panelY1 + target.getHeight();
                                                changedPosition = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                });
            }
            if (panelY1 > INITIAL_Y_POSITION) panelY1 += LAYOUT_MARGIN_Y;
            target.setPosition(panelX1, panelY1);
        },
    });
