
// datastore for vTables
var emptyDataStore = new Ext.data.JsonStore({
    url : 'com.plusmpm.servlet.virtualtables.getJsonValues.customServlet',
    // bo metoda POST nic nie robi
    method : 'POST',
    storeId: 'emptyDataStore',
    // reader configs
    idIndex: 0,
    fields: []
});


//=====================================================================
//===================  Store dla Typow  ===============================
//=====================================================================

var typeStore;

function getTypeStore() {
	typeStore = new Ext.data.JsonStore({
		proxy: new Ext.data.HttpProxy({
				method: 'GET',
				url: 'com.plusmpm.servlet.virtualtables.getJsonTypes.customServlet',
				timeout: 300000
			}),
		id : 'typeStore',
		root : 'types',
		idProperty : 'id',
		fields : [ 'id', 'typeName', 'typeDesc' ]
				
	});
	return typeStore;
}

//=====================================================================
//===================  Store dla Tabel  ===============================
//=====================================================================

var tableDataStore;

proxy = new Ext.data.HttpProxy({
	method : 'GET',
	url : 'com.plusmpm.servlet.virtualtables.getJsonTables.customServlet',
	timeout: 300000
});

writer = new Ext.data.JsonWriter({
	encode : true,
	writeAllFields : false
});

function getTableDataStore() {
	if (tableDataStore == undefined) {
		// create the Data Store for the grid
		tableDataStore = new Ext.data.JsonStore( {
			deletedRecords : new Array(0),
			autoSave : false,
			proxy : proxy,
			writer : writer,
			root : 'tables',
			idProperty : 'id',
			// nowy jest undefined i nie wyswietlany.
			// sluzy dla odroznienia nowych rekordow
			// zeby mozna bylo edytowac ich id
			fields : [ 'tableName', 'id', 'tableDesc', 'userId', 'rows',
					'columns']
		});
	}
	return tableDataStore;
}

//=====================================================================
//===================  Store dla Kolumn  ==============================
//=====================================================================

var columnsDataStore;

function getColumnsDataStore() {
	if (columnsDataStore == undefined) {
		// create the Data Store for the grid
		columnsDataStore = new Ext.data.JsonStore( {
			proxy: new Ext.data.HttpProxy({
				method: 'GET',
				url: 'com.plusmpm.servlet.virtualtables.getJsonColumns.customServlet',
				timeout: 300000
			}),
			deletedRecords : new Array(0),
			baseParams: {tableId: ''},
			root : 'columns',
			idProperty : 'id',
			fields : [ 'columnName', 'id', 'columnDesc', 'typeId', 'typeName',
					'typeDesc' ]
		});
	}
	return columnsDataStore;
}

//=====================================================================
//===================  Store dla Wartosci  ============================
//=====================================================================
//===================  bedzie dynamiczne generowany JavaScript
//===================  zeby obslugiwac rozne kolumny..
//=================== (jest servlet do tego: getValuesJavaScript
//=====================================================================