

// Vtype dla danych, jakie można wpisywac
// zamaskowalismy grozne dla servletow znaki..
Ext.apply(Ext.form.VTypes, {
    qbVtInput:  function(v) {
        return /^[\.1-90a-zA-Z \-_@!*:;,()ęóąśłżźćńĘÓĄŚŁŻŹĆŃ\-:\+\\\/=]*$/.test(v);
    },
    qbVtInputText: PW.t('dopuszczalne_znaki'),
    qbVtInputMask: /[\.1-90a-zA-Z \-_@!*:;,()ęóąśłżźćńĘÓĄŚŁŻŹĆŃ\-\+\\\/=]/i
});

// dla identyfikatorów (bez spacji bez polskich)
Ext.apply(Ext.form.VTypes, {
    qbVtIdInput:  function(v) {
        return /^[\.1-90a-zA-Z\-_\-:]*$/.test(v);
    },
    qbVtIdInputText: PW.t('dopuszczalne_znaki'),
    qbVtIdInputMask: /[\.1-90a-zA-Z\-_\-:]/i
});




function getIdEditor(){
	return new Ext.grid.GridEditor(new Ext.form.TextField( {
		allowBlank : false,
		maxLength : 255,
		vtype : 'qbVtIdInput'
		}));
}

function getNameEditor(){
	return new Ext.grid.GridEditor(new Ext.form.TextField( {
		allowBlank : true,
		maxLength : 255,
		vtype : 'qbVtInput'
		}));
}

function getDescEditor(){
	return new Ext.grid.GridEditor(new Ext.form.TextField( {
		allowBlank : true,
		vtype : 'qbVtInput'
	}));
}


// pusty
var emptyColumnModel = new Ext.grid.ColumnModel( {
	columns : []
});


//=====================================================================
//============  ColumnModel dla Tabel  ================================
//=====================================================================

var tableNameWidth = 100;
var tableIdWidth = 110;
var userIdWidth = 80;
var tableDescWidth = 170;
var numberOfRecordsWidth = 50;

var tablesColumnModel = new Ext.grid.ColumnModel( {
	defaults : {
	// becouse columns are not sortable by default
		sortable : true
	},
	columns : [ {
		header : PW.t('nazwa_tabeli'),
		dataIndex : 'tableName',
		id : 'tableName',
		width : tableNameWidth,
		editor : getNameEditor()
	}, {
		header : PW.t('id_tabeli'),
		dataIndex : 'id',
		id : 'tableId',
		width : tableIdWidth,
		sorted : true,
		editor : getIdEditor()
	}, {
		header : PW.t('opis_tabeli'),
		dataIndex : 'tableDesc',
		id : 'tableDesc',
		width : tableDescWidth,
		editor : getDescEditor()
	}, {
		header : PW.t('tworca'),
		dataIndex : 'userId',
		id : 'userId',
		width : userIdWidth
	}, {
		header : PW.t('ilosc_wierszy'),
		dataIndex : 'rows',
		id : 'rows',
		type : 'int',
		width : numberOfRecordsWidth
	} ]
});

//=====================================================================
//============  ColumnModel dla Kolumn  ===============================
//=====================================================================

var columnNameWidth = 80;
var columnIdWidth = 65;
var columnDescWidth = 80;
var typeNameWidth = 70;
var typeIdWidth = 90;
var typeNameDesc = 80;

// to bylo jednak potrzebne #>
Ext.QuickTips.init();

var columnsColumnModel = new Ext.grid.ColumnModel( {
	defaults : {
	// becouse columns are not sortable by default
		sortable : true
	},
	columns : [ {
		header : PW.t('nazwa_kolumny'),
		dataIndex : 'columnName',
		id : 'columnName',
		width : columnNameWidth,
		editor : getNameEditor()
	}, {
		header : PW.t('id_kolumny'),
		dataIndex : 'id',
		id : 'columnId',
		width : columnIdWidth,
		sorted : true,
		editor : getIdEditor()
	}, {
		header : PW.t('opis_kolumny'),
		dataIndex : 'columnDesc',
		id : 'columnDesc',
		width : columnDescWidth,
		editor : getDescEditor()
	}, {
		header : PW.t('id_typu'),
		dataIndex : 'typeId',
		id : 'typeId',
		width : typeIdWidth,
		editor: new Ext.form.ComboBox({
                    tpl : '<tpl for="."><div ext:qtip="<B>{id}</B><BR />{typeDesc}" class="x-combo-list-item">{typeName}</div></tpl>',
					store : getTypeStore(),
					allowBlank: false,
                    id : 'typeComboBox',
                    //typeAhead: true,
                    displayField : 'typeName',
                    valueField : 'id',
                    lazyRender : true,
                    triggerAction: 'all',
                    mode: 'remote',
        			forceSelection: true
                })
	}]
});

//=====================================================================
//============  ColumnModel dla Wartosci  =============================
//=====================================================================

// będzie generowany dynamicznie na serwerze w zależności od tabeli