(function (Ext) {
    Ext.define('Suncode.deactivateUsers.view.Assignments', {
        extend: 'Ext.form.Panel',
        alias: 'widget.assignments-panel',
        id: 'assignment-panel',

        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        frame: true,
        autoScroll: true,
        defaults: {
            margin: '10 5 10 5'
        },

        initComponent: function () {
            this.items = [{
                xtype: 'tasks-section'
            }];

            if (window.isDeactivationEditMode == false) {
                this.items.push({
                    xtype: 'others-section',
                });
            }

            this.callParent();
            this.initStores();
        },

        initStores: function () {
            this.usersStore = new Ext.create('Suncode.deactivateUsers.store.UsersStore');
            this.groupsStore = new Ext.create('Suncode.deactivateUsers.store.GroupsStore');
        }
    });

}(this.Ext4));