(function (Ext) {
  Ext.define('Favourites.settings.view.Viewport', {
    extend: 'Ext.container.Container',
    xtype: 'favourites-settingsviewport',

    requires: ['Favourites.settings.view.FavouriteSets', 'Favourites.settings.view.Editor'],

    height: 700,
    layout: 'border',
    style: {
      background: 0,
    },
    items: [
      {
        xtype: 'favourites-sets',
        flex: 1,
        region: 'center',
        layout: {
          type: 'vbox',
          align: 'stretch',
        },
      },
      {
        xtype: 'panel',
        region: 'east',
        flex: 1,
        title: Favourites.I18N.m('settings.editor', ''),
        frame: true,
        collapsible: true,
        split: true,
        layout: 'card',
        bodyStyle: {
          border: '0',
        },
        defaults: {
          border: false,
        },
        items: [
          {
            id: 'favourites-welcome',
            html:
              '<h3>' + Favourites.I18N.m('settings.editor.blank') + '</h3><p>' + Favourites.I18N.m('settings.editor.blank.info') + '</p>',
          },
          {
            xtype: 'favourites-editor',
          },
        ],
      },
    ],
  });
})(Ext4);
