(function (Ext) {
  Ext.define('Favourites.settings.view.NewSetToolbar', {
    extend: 'Ext.toolbar.Toolbar',
    xtype: 'favourites-settoolbar',

    initComponent: function () {
      var me = this;

      me.items = [
        {
          xtype: 'tbtext',
          text: Favourites.I18N.m('settings.sets.new'),
        },
        {
          xtype: 'textfield',
          name: 'name',
          emptyText: Favourites.I18N.m('set.name'),
          allowBlank: false,
          validateOnBlur: false,
          validateOnChange: false,
          flex: 1,
          listeners: {
            specialkey: Ext.bind(me.handleSpecialKey, me),
          },
        },
        {
          xtype: 'textfield',
          name: 'description',
          emptyText: Favourites.I18N.m('set.description'),
          flex: 2,
          listeners: {
            specialkey: Ext.bind(me.handleSpecialKey, me),
          },
        },
        {
          xtype: 'button',
          tooltip: Favourites.I18N.m('add'),
          iconCls: 'dvnt-icon-plus-circle',
          handler: Ext.bind(me.createSet, me),
        },
      ];

      me.callParent(arguments);

      (me.nameField = me.down('textfield[name="name"]')), (me.descField = me.down('textfield[name="description"]'));
    },

    handleSpecialKey: function (field, e) {
      if (e.getKey() == e.ENTER) {
        this.createSet();
      }
    },

    createSet: function () {
      var me = this,
        name = me.nameField,
        desc = me.descField;

      if (name.isValid()) {
        me.fireEvent('createSet', name.getValue(), desc.getValue(), me);
      }
    },

    reset: function () {
      var me = this;

      me.nameField.reset();
      me.descField.reset();
    },
  });
})(window.Ext4);
