(function (Ext) {
  Ext.define('Favourites.settings.controller.SettingsController', {
    extend: 'Ext.app.Controller',

    models: ['Favourites.model.FavouritesSet'],
    stores: ['Favourites.store.FavouritesSets', 'Favourites.store.FavouriteDefinitions'],

    refs: [
      {
        ref: 'favouritesSets',
        selector: 'favourites-sets',
      },
      {
        ref: 'editor',
        selector: 'favourites-editor',
      },
    ],
      badRequestHttpCode: 400,

    init: function () {
      var me = this;

      me.control({
        'favourites-sets': {
          afterrender: me.reloadStore,
          deleteSet: me.deleteSet,
          beforeselect: me.checkDisplayEditor,
          selectionchange: me.displayEditor,
        },

        'favourites-settoolbar': {
          createSet: me.createSet,
        },
      });
    },

    getFavouritesStore: function () {
      return this.getStore('Favourites.store.FavouritesSets');
    },

    reloadStore: function () {
      var me = this,
        store = me.getFavouritesStore();

      store.load();
    },

    checkDisplayEditor: function (sm, record, index) {
      var me = this,
        editor = me.getEditor();

      if (editor.isDirty()) {
        Ext.Msg.confirm(
          Favourites.I18N.m('settings.editor.pendingchanges.title'),
          Favourites.I18N.m('settings.editor.pendingchanges.msg', record.get('name')),
          function (button) {
            if (button === 'yes') {
              editor.cancel(true);
              sm.select(record);
            }
          }
        );
        return false;
      }
      return true;
    },

    displayEditor: function (grid, selected) {
      var me = this,
        editor = me.getEditor(),
        record = selected[0],
        card = editor.ownerCt.getLayout();

      if (record) {
        editor.edit(record);
        card.setActiveItem(editor);
      } else {
        card.setActiveItem(0);
      }
    },

    createSet: function (name, description, toolbar) {
      var me = this,
        store = me.getFavouritesStore(),
        sm = me.getFavouritesSets().getSelectionModel(),
        set;

      set = Ext.create('Favourites.model.FavouritesSet', {
        name: name,
        description: description,
      });

      set.save({
        success: function (record, operation) {
          toolbar.reset();
          store.add(record);
          sm.select(record);
        },
          failure: function (data, response) {
              if (response.error.status === me.badRequestHttpCode) {
                  Ext.Msg.show({
                      title: Favourites.I18N.m('error'),
                      msg: Favourites.I18N.m('favourites.set.name.exception'),
                      buttons: Ext.Msg.OK,
                      icon: Ext.Msg.ERROR,
                  });
              } else {
                  Ext.Msg.show({
                      title: Favourites.I18N.m('error'),
                      msg: Favourites.I18N.m('error.set.create'),
                      buttons: Ext.Msg.OK,
                      icon: Ext.Msg.ERROR,
                  });
              }
          }
      });
    },

    deleteSet: function (set) {
      set.destroy();
    },
  });
})(Ext4);
