(function (Ext) {
  Ext.define('Favourites.model.FavouriteDefinition', {
    extend: 'Ext.data.TreeModel',

    fields: [
      { name: 'type', mapping: 'definition.type' },
      { name: 'name', mapping: 'definition.name' },
      { name: 'displayName', mapping: 'definition.displayName' },
      { name: 'description', mapping: 'definition.description' },
      { name: 'typeDescription', mapping: 'definition.typeDescription' },
      { name: 'displayNameMode', mapping: 'definition.displayNameMode' },
      { name: 'parameter', type: 'auto', mapping: 'definition.parameter' },
      { name: 'countable', mapping: 'definition.countable' },
      { name: 'supported', mapping: 'definition.supported' },
      { name: 'childrens', type: 'auto', defaultValue: null },
      {
        name: 'leaf',
        type: 'boolean',
        convert: function (v, rec) {
          if (rec.data.id === 'root') {
            return false;
          }
          return Ext.isEmpty(rec.data.childrens);
        },
      },
    ],
  });
})(window.Ext4);
