jQuery.extend(PW.ui.CaptchaConfirmation, {
	deleteButtonText: PW.t('bulkDelete.deleteButtonText'),
	cancelButtonText: PW.t('bulkDelete.cancelButtonText'),
    acceptButtonText: PW.t('bulkAccept.acceptButtonText'),
	show: function (config) {
        function generateUuid() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }

        function generateCaptchaImageHtml(uuid) {
            return '<div style="vertical-align:middle; border-width: 2px; margin-top: 10px"><img src="' + 'api/captcha/' + uuid + '" style="max-height:90%; max-width:90%;display: block; margin: auto;border-width: 1px; border-color: Black; border-style: solid;"/></div>';
        }

        function generateCaptchaImageComponent(uuid) {
            return {
                id: 'captchaImage',
                xtype: 'panel',
                hidden: !requiresCaptcha,
                width: 300,
                height: 65,
                border: false,
                frame: false,
                html: generateCaptchaImageHtml(uuid)
            }
        }

        var captchaUuid = generateUuid()
        var requiresCaptcha = !!config.requiresCaptcha;
        var buttonText = config.operation === 'accept' ? 
            PW.ui.CaptchaConfirmation.acceptButtonText : PW.ui.CaptchaConfirmation.deleteButtonText;
        
        new Ext.Window({
            title: config.title,
            layout: 'fit',
            modal: true,
            border: false,
            frame: false,
            resizable: false,
            width: 500,
            listeners: {
            	afterrender: function() {
            		var height = 0,
            			content = this.getComponent('content');
            		
            		content.items.each(function( item ){
            			height += item.getHeight();
            		}, this);
            		
            		content.setHeight( height + 80 );
            	}
            },
            items: [
                {
                    xtype: 'panel',
                    itemId: 'content',
                    border: false,
                    frame: false,
                    style: 'padding: 5px 5px 0 5px',
                    layout: {
                        type: 'vbox',
                        align: 'center',
                    },
                    items: [
                        {
                            xtype: 'label',
                            style: 'text-align: center',
                            html: config.msg,
                            height: 75
                        },
                        generateCaptchaImageComponent(captchaUuid),
                        {
                            xtype: 'label',
                            hidden: !requiresCaptcha,
                            text: PW.t('enterCodeFromImage')
                        },
                        {
                            id: 'captchaField',
                            hidden: !requiresCaptcha,
                            xtype: 'textfield',
                            width: '150px'
                        }
                    ],
                    buttonAlign: 'center',
                    buttons: [
                        {
                            text: buttonText,
                            handler: function (button) {
                                if (requiresCaptcha) {
                                    var captchaValue = Ext.getCmp('captchaField').getValue()
                                    Ext.Ajax.request({
                                        url: 'api/captcha/validate',
                                        method: 'POST',
                                        params: {
                                            captcha: captchaValue,
                                            uuid: captchaUuid
                                        },
                                        success: function () {
                                            config.fn.apply(config.scope);
                                            button.findParentByType('window').close();
                                        },
                                        failure: function () {
                                            var win = button.findParentByType('window');
                                            var captchaImage = win.findById('captchaImage');
                                            var parentComponent = captchaImage.findParentByType('panel');
                                            parentComponent.remove(captchaImage);

                                            captchaUuid = generateUuid();
                                            parentComponent.insert(1, generateCaptchaImageComponent(captchaUuid));
                                            win.doLayout();

                                            PW.ui.Message.error(PW.t('Kod_z_obrazka_jest_nieprawidlowy'));
                                        },
                                        scope: this
                                    });
                                }
                                else {
                                    config.fn.apply(config.scope);
                                    button.findParentByType('window').close()
                                }
                            }
                        },
                        {
                            text: PW.ui.CaptchaConfirmation.cancelButtonText,
                            handler: function (button) {
                                button.findParentByType('window').close();
                            }
                        }
                    ]
                }
            ],
        }).show();
    },
    getBulkDeleteMessage: function( resource, count, requiresCaptcha ) {
    	var captchaPart = requiresCaptcha ? PW.t('bulkDelete.warningText.captchaPart') : '',
    		resourceKey = 'bulkDelete.resource.' + resource;
    	return PW.t('bulkDelete.warningText', count, PW.t(resourceKey), captchaPart, PW.ui.CaptchaConfirmation.deleteButtonText);
    },

    getBulkAcceptMessage: function(count, requiresCaptcha ) {
        var captchaPart = requiresCaptcha ? PW.t('bulkDelete.warningText.captchaPart') : '';
        return PW.t('bulkAccept.warningText', count, captchaPart, PW.ui.CaptchaConfirmation.acceptButtonText);
    }
});
