(function(window) {
	jQuery.extend(PW.ui, {
		Selectize: {}
	});

	jQuery.extend(PW.ui.Selectize, {
		resizeInputLength : 10,

		initBase : function(id, config) {
			let input = jQuery(id).selectize(jQuery.extend(true,{
		    	plugins : {
					'remove_button' : {
						title : PW.t('usun')
					},
					'restore_on_backspace' : {},
					'restore_on_click' : {},
					'calculate_input_width_while_using_arrows' : {},
					'calculate_input_width_on_paste' : {},
					'copy_paste_tags' : {}
				},
				delimiter : ';',
				dropdownParent : 'body',
				persist : false,
				createOnBlur : true,
				create : false,
				maxItems : null,
				maxInputWidth: null,
			}, config))

			if (input.length > 0) {
				input[0].selectize.positionDropdown();
			}

			jQuery(id).on('keyup keypress keydown update blur', function(e) {
				var keyCode = e.keyCode || e.which;
				if (keyCode === 13) {
					e.preventDefault();
					return false;
				}
				var input = jQuery(this.previousElementSibling).get(0).selectize;

				if ( typeof input != 'undefined' ){
		        	if (input.caretPos < input.items.length){
		        		PW.ui.Selectize._resizeInputWidth(input,PW.ui.Selectize.resizeInputLength);
		        	}
		        	else{
		        		PW.ui.Selectize._setFullInputWidth(input);
		        	}
				}
			});
		},

		initInput : function(id, config) {
			config = jQuery.extend({
				onFocus : fullInputWidth,
				onItemRemove : itemRemove
			},config);

			PW.ui.Selectize.initBase(id, config);

			function fullInputWidth(){
				PW.ui.Selectize._setFullInputWidth(this);
			}

			function itemRemove() {
                this.clearOptions();
			}
		},

		initSelect : function(id, config) {
			config = jQuery.extend({
				valueField : 'id',
				labelField : 'title',
				searchField : 'title'
			},config);

			PW.ui.Selectize.initBase(id, config);
		},

		_addValueToInput: function(input) {
		    // dodaje wpisaną wartość do selecta (prawdziwego i selectize jako bloczek)

		    var $input = input.$control_input;
		    var inputId = $input[0].id;
		    var mainInputId = inputId.replace('-selectized', '');

		    var inputValues = $input.val().split(';');

		    inputValues.forEach(function (inpVal) {
		    	inputValue = inpVal.trim();
		    	if ( inputValue.trim() !== "" ){
			        var sInput = jQuery('#' + mainInputId)[0].selectize;
			        sInput.addOption({
			            value : inputValue,
			            text : inputValue
			        });

			       sInput.addItem(inputValue);

			       sInput.setTextboxValue("");
			    }
		    });

		    // ustawia kursor na koniec inputa (potrzebny przy edycji opcji)
		    input.setCaret(input.items.length);

		    PW.ui.Selectize._setFullInputWidth(input);
		},

		_copyValueToClipboard: function(value) {
			var el = document.createElement('textarea');
			el.value = value;
			el.setAttribute('readonly', '');
			el.style = {position: 'absolute', left: '-9999px'};
			document.body.appendChild(el);

			el.select();
			document.execCommand('copy');

			document.body.removeChild(el);
		},

		_copyAllValuesToClipboard: function(input){
			var values = input.items.join(";");
			PW.ui.Selectize._copyValueToClipboard(values);
		},

		_setFullInputWidth: function(input){
			/*
			 * wylicza i ustawia szerokość inputa selectize do końca diva, żeby była możliwość
			 * wklejania zawartośći pod prawym przyciskiem myszy
			 */
			var divS = input.$control[0];
			var inputS = input.$control_input[0];

			var minusPxs = 9 + +divS.getStyle('padding-left').replace('px','') + +divS.getStyle('padding-right').replace('px','') + +inputS.getStyle('margin-left').replace('px','') + +inputS.getStyle('margin-right').replace('px','');
			var width = divS.getWidth() - minusPxs;

			if ( typeof maxInputWidth == 'undefined' )
			{
				maxInputWidth = width;
			}

			if (inputS.offsetLeft > 0){
				if( width > maxInputWidth )
				{
					width = maxInputWidth;
				}

				inputS.style.width = (width - inputS.offsetLeft).toString() + "px";
			}
			else
			{
				maxInputWidth = divS.getWidth() - 8 - minusPxs;;
			}

		},

		_resizeInputWidth: function(input, pixels){
			/*
			 * zmienia szerokość inputa selectize o ilosc pikseli w parametrze 'pixels'
			 */
			var inputS = input.$control_input[0];

			if (!Selectize.$testInput) {
				Selectize.$testInput = $('<span />',{
					position: 'absolute',
					top: -99999,
					left: -99999,
					width: 'auto',
					padding: 0,
					whiteSpace: 'pre'
				});
			}

			Selectize.$testInput.text(inputS.value);

			currentWidth = Selectize.$testInput.width();

			var width = +currentWidth + pixels;
			if( width > maxInputWidth )
			{
				width = maxInputWidth;
			}
			inputS.style.width = width.toString() + "px";
			inputS.style.minWidth = "0px";
		},

		_setSizeInputWidth: function(input, pixels){
			/*
			 * zmienia szerokość inputa selectize
			 */
			var inputS = input.$control_input[0];
			inputS.style.width = pixels.toString() + "px";
			inputS.style.minWidth = "0px";
		}
	});
})(window);

Selectize.define('restore_on_click', function(options) {
	var self = this;

	options.text = options.text || function(option) {
		return option[this.settings.labelField];
	};

	this.onClick = (function() {
		var original = self.onClick;
		return function(e) {
			if (this.$control_input.val() === '' ) {
				if(this.$activeItems.length == 1){
					var val = this.$activeItems[0].dataset.value;
					var option = this.options[val];
					if (this.deleteSelection(e)) {
						this.setTextboxValue(options.text.apply(this,
								[ option ]));

						if (this.caretPos < this.items.length){
							PW.ui.Selectize._resizeInputWidth(this,PW.ui.Selectize.resizeInputLength);
						}
						else{
							PW.ui.Selectize._setFullInputWidth(this);
						}

						this.clearOptions();
					}
				}
			}
			return original.apply(this, arguments);
		};
	})();

	this.onItemSelect = (function($item, e) {
		var original = self.onItemSelect;
		return function(e) {
			if(this.$control_input.val() !== ''){
			    PW.ui.Selectize._addValueToInput(this);
			}

			return original.apply(this, arguments);
		};
	})();
});

Selectize.define('copy_paste_tags', function(options) {
	var self = this;

	this.onMouseDown = (function($item, e) {
		var original = self.onMouseDown;
		return function(e) {
			if (e.button == 2) {
				if (this.$activeItems.length == 1) {
					if(this.$activeItems[0].offsetParent.hasClassName('selectizeInput')
							|| this.$activeItems[0].offsetParent.hasClassName('selectizeInputVar')){
						var value = this.$activeItems[0].dataset.value;
						var input = this;
						var menu = new Ext.menu.Menu({
	                        items: [{
	                            text: PW.t('copy'),
	                            handler: function() {
	                            	PW.ui.Selectize._copyValueToClipboard(value);
	                            }
	                        },{
	                            text: PW.t('copyAll'),
	                            handler: function() {
	                            	PW.ui.Selectize._copyAllValuesToClipboard(input);
	                            }
	                        }],
                            render : function(){
                                Ext.menu.Menu.superclass.render.call(this);
                                this.el.on("contextmenu", Ext.emptyFn, this, {preventDefault: true});
                            }
	                    }).showAt([e.pageX, e.pageY]);
					}
				}
				else {
					this.focus();
				}
			    return original.apply(this, arguments);
			}
		};
	})();
});

Selectize.define('calculate_input_width_while_using_arrows', function(options) {
	var self = this;

	this.onKeyDown = (function($item, e) {
		var original = self.onKeyDown;
		return function(e) {
			original.apply(this, arguments);

			if ( e.which != 0 )
			{
				if ( this.$control_input.val().length == 0){
					//dlugość tekstu w input jest == 0 czyli przechodzimy między tagami, a nie między literami podczas edycji tagu
					if (e.which >= 37 && e.which <= 40){
						//strzalki
						if (e.which == 39 && this.caretPos >= this.items.length){
							//przejscie w prawo z przedostatniej pozycji na koniec
							PW.ui.Selectize._setFullInputWidth(this);
						}
						else{
							PW.ui.Selectize._setSizeInputWidth(this,PW.ui.Selectize.resizeInputLength);
						}
					}
				}
			}
		};
	})();


});

Selectize.define('calculate_input_width_on_paste', function(options) {
	var self = this;

	this.onPaste = (function($item, e) {
		var original = self.onPaste;
		return function(e) {
			var $original = original;

			var $this = this;
			if ($this.caretPos >= $this.items.length){
				PW.ui.Selectize._setFullInputWidth($this);
			}
			else{
				PW.ui.Selectize._resizeInputWidth($this,PW.ui.Selectize.resizeInputLength);
			}
		};
	})();
});
