<%@page import="com.suncode.pwfl.administration.user.security.captcha.service.CaptchaService"%>
<%@page import="com.suncode.pwfl.util.SpringContext"%>
<%@page import="com.suncode.pwfl.administration.configuration.DefinedSystemParameter"%>
<%@page import="com.suncode.pwfl.administration.configuration.SystemProperties"%>
<%@page import="com.suncode.pwfl.SystemVersion" %>

<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>

<c:set var="prosze__czekac"><spring:message code="prosze__czekac" /></c:set>
<c:set var="Ostrzezenie"><spring:message code="Ostrzezenie" /></c:set>
<c:set var="Zaloguj"><spring:message code="Zaloguj" /></c:set>
<c:set var="Zaloguj_automatycznie"><spring:message code="Zaloguj_automatycznie" /></c:set>
<c:set var="Odswiez"><spring:message code="Odswiez" /></c:set>


<script type="text/javascript">
	function prepareCsrfToken(config) {
		Ext.Ajax.request({
			url: Suncode.getAbsolutePath("api/csrf/token"),
			success: function (response) {
				var tokenDto = JSON.parse(response.responseText);

				Suncode.refreshCsrfToken(tokenDto.token);
				document.querySelector("#login-csrf-input")
						.setAttribute("value", Suncode.getCsrfToken());

				if (config.success) {
					config.success();
				}
			},
			failure: function (response) {
				if (config.failure) {
					config.failure(response);
				}
			}
		});
	}

	let authenticationButtons = JSON.parse('${authenticationButtons}');
	let loginManual = ${loginManual};
	let autoLogin = ${autoLogin};

	if (!loginManual && authenticationButtons.length == 1 && autoLogin) {
		var button = authenticationButtons[0];
		if (button.autoLogin === true && button.redirectType == 'POST') {
			prepareCsrfToken({
				success: function () {
					doSSOPost(button);
				}
			});
		}
	}

	function doSSOPost(button) {
	    var form = document.createElement('form');
	    form.method = 'post';
	    form.action = button.url;

		var csrfField = document.createElement('input');
		csrfField.type = 'hidden';
		csrfField.name = Suncode.getCsrfParameterName();
		csrfField.value = Suncode.getCsrfToken();
		form.appendChild(csrfField);

	    jQuery.each(button.postParameters, function(index, value) {
	        var hiddenField = document.createElement('input');
	        hiddenField.type = 'hidden';
	        hiddenField.name = index;
	        hiddenField.value = value;

	        form.appendChild(hiddenField);
	    });

	    document.body.appendChild(form);
	    form.submit();
	}

	jQuery(document).ready(function() {
		var domainField = jQuery('#domainName');
		if( domainField.length > 0 ) {
			domainField[0].value = localStorage['selectedDomain'];
			if ( domainField[0].value == '' ){
				var firstVal = jQuery('#domainName option:first').val();
				domainField[0].value = firstVal;
				localStorage['selectedDomain'] = firstVal;
			}

			domainField.on('change', function() {
				localStorage['selectedDomain'] = this.value;
			});
		}
	});
</script>

<div class="login-card">
	<div class="logo-text-container">
		<div id="login-logo">
			<img src="${pageContext.request.contextPath}/resources/images/plusworkflow_color_full.png"/>
		</div>
		<div class="system-version">
			<%=SystemVersion.getVersionIdentifier() %>
		</div>
	</div>

	<div class="login-system-version-container">

		<jsp:include page="../util/showSystemType.jsp">
			<jsp:param name="trialServiceStyleClassName" value="login-system-version"/>
			<jsp:param name="systemTrialStyleClassName" value="login-system-version"/>
		</jsp:include>

	</div>

	<div id="message" class="hide message-box error">
		<c:out value="${message}" />
	</div>
	<div id="login-form">
			<form id="loginForm" action="${pageContext.request.contextPath}/Login.do" onSubmit="return doLogin()" method="POST">
				<input id="login-csrf-input" type="hidden" name="${_csrf.parameterName}" value="${_csrf.token}"/>
				<input type="hidden" id="redirectUrl" name="redirectUrl" value="<c:out value="${redirectUrl}"/>" />
				<c:if test='${!hideLoginForm}'>
					<div class="gl-grid-middle">
						<div class="gl-col-4">
							<label class="dvnt-table-black dvnt-body1"
								   for="username"><spring:message code="Uzytkownik"/></label>
						</div>
						<div class="gl-col-8">
							<div class="dvnt-input-text-wrapper">
								<input type="text"
									   name="username"
									   id="username"
									   autofocus/>
							</div>
						</div>
						<div class="gl-col-4">
							<label class="dvnt-table-black dvnt-body1"
								   for="password"><spring:message code="Haslo" /></label>
						</div>
						<div class="gl-col-8">
							<table class="form" style="width: 100%">
								<tbody>
								<tr>
									<td>
										<div class="triggers">
											<a id="showHidePassword" class="trigger first dvnt-icon-show hide-password-trigger z-index-1"></a>
											<div class="dvnt-input-text-wrapper">
												<input type="password"
													   name="password"
													   id="password"
													   autofocus/>
											</div>
										</div>

									</td>
								</tr>
								</tbody>
							</table>
						</div>
						<div id="captcha-container"
							 style="display: none"
							 class="gl-col-12 gl-grid">
							<div class="gl-col-4">
								<label class="dvnt-table-black dvnt-body1">
									<spring:message code="Kod_bezpieczenstwa"/>
								</label>
							</div>
							<div class="gl-col-8">
								<div class="captcha-form-container">
									<div class="captcha-image-container">
										<img id="captcha-image" />
									</div>
									<div class="captcha-refresh">
										<input class="dvnt-button-secondary"
											   type="button"
											   onClick="showCaptchaField(); return false;"
											   value="<c:out value="${Odswiez}"/>"/>
									</div>
									<div class="dvnt-input-text-wrapper">
										<input type="text" name="captcha" id="captcha" placeholder="<spring:message code="Wpisz_kod"/>" />
									</div>
								</div>
							</div>
						</div>
						<c:if test='${setDomain == "TRUE"}'>
							<div class="gl-col-4">
								<label class="dvnt-table-black dvnt-body1"
									   for="domainName"><spring:message code="Domena"/></label>
							</div>
							<div class="gl-col-8">
								<div class="dvnt-combobox-wrapper">
									<select name="domainName" id="domainName">
										<c:forEach var="element" items="${alDomains}">
											<option value='<c:out value="${element.id}"/>'>
												<c:out value="${element.domainName}"/>
											</option>
										</c:forEach>
										<option value='plusworkflow'><spring:message code="Plus_Workflow"/></option>
									</select>
								</div>
							</div>
						</c:if>
						<div class="gl-col-12">
							<%if (SystemProperties.getBoolean(DefinedSystemParameter.PASSWORD_RECOVERY_ENABLED)) {%>
							<div onclick="location.href = Suncode.getContextPath() + '/PasswordRecovery.do'"
								 class="password-recovery" <c:if test="${alDomains.size()>0}">style="display: none"</c:if>>
								<spring:message code="Nie_pamietam_hasla"/>
							</div>
							<%}%>
						</div>
						<div class="gl-col-6">
							<c:if test="${showAutoLogin}">
								<input class="dvnt-button-primary"
									   type="button"
									   onClick="doAutoLogin(); return false;"
									   value="<c:out value="${Zaloguj_automatycznie}"/>"/>
							</c:if>
						</div>
						<div class="gl-col-6">
							<input class="dvnt-button-primary"
								   type="submit"
								   value="<c:out value="${Zaloguj}"/>"/>
						</div>
					</div>
				</c:if>
			</form>
		<div class="authentication-buttons">
		</div>
	</div>
</div>

<script type="text/javascript">
	(function () {
		var autoLoginFailure = PW
				.t('Logowanie_automatyczne_nie_powiodlo_sie_Zaloguj_sie_uzywajac_loginu_i_hasla');

		var messageTarget = Ext.get('message');

		var autoLoadingMask = new Ext.LoadMask(Ext.getBody(), {
			msg : PW.t('Trwa_logowanie_automatyczne_Prosze_czekac'),
			msgCls : 'x-mask-loading'
		});

		var loginMask = new Ext.LoadMask(Ext.get('loginBody'), {
			msg : PW.t('Trwa_logowanie')
		});

		function doAutoLogin() {
			var redirect = Ext.get("redirectUrl").getValue();
			window.location.replace(Suncode
					.getAbsolutePath("/sso/login.do?redirectUrl="
							+ encodeURIComponent(redirect)));
		}

		function showCaptchaField() {
			captchaId = generateUuid();
			jQuery('#captcha-container').show();
			jQuery('#captcha-image').attr('src', 'api/captcha/' + captchaId);
			jQuery('#captcha').val('');
		}

		var requireCaptcha = JSON.parse(<%=SpringContext.getBean( CaptchaService.class ).requireCaptcha(session)%>);
		var captchaId;

		jQuery(document).ready(function () {
			var domainField = jQuery('#domainName');
			if(domainField.length == 0 || domainField.val() == 'plusworkflow') {
				jQuery('.password-recovery').show();
				if(requireCaptcha) {
					showCaptchaField();
				}
			}

			domainField.change(function(event) {
				if(event.target.value == 'plusworkflow') {
					jQuery('.password-recovery').show();

					if(requireCaptcha) {
						showCaptchaField();
					}
					else {
						jQuery('#captcha-container').hide();
					}
				}
				else {
					jQuery('.password-recovery').hide();
					jQuery('#captcha-container').hide();
				}
			});

			var $buttonsContainer = jQuery('.authentication-buttons');
			jQuery.each( authenticationButtons, function( index, button ) {
				var link;
			    if (button.redirectType == 'POST') {
			        link = jQuery('<a/>', {
			            text: button.name,
			            "class": 'form-button'
			        });

			        link.get(0).addEventListener("click", function() {
			            doSSOPost(button);
			        }, false);
			    } else {
			        link = jQuery('<a/>', {
			            href: button.url,
			            text: button.name,
			            "class": 'form-button'
			        });
			    }

			    if (button.styles) {
			        link.css(button.styles);
			    }
			    $buttonsContainer.append(link);
			});

			jQuery("#showHidePassword").on('click', function (event) {
				event.preventDefault();
				const passwordInput = jQuery('#password')[0];
				const hideIconClass = 'dvnt-icon-hide';
				const showIconClass = 'dvnt-icon-show';

				if (passwordInput.type === 'password') {
					passwordInput.type = 'text';
					jQuery(this).removeClass(showIconClass);
					jQuery(this).addClass(hideIconClass);
				} else {
					passwordInput.type = 'password';
					jQuery(this).removeClass(hideIconClass);
					jQuery(this).addClass(showIconClass);
				}
			})
		});

		function doLogin() {
			loginMask.show();

			var password = Ext.get("password").dom.value;
			var username = Ext.get("username").dom.value;
			var domainId = null;
			var domainLoging = false;

			if (Ext.get("domainName") != null) {
				domainId = Ext.get("domainName").dom.value;
				domainLoging = true;
			}
			else {
				domainId = 'plusworkflow';
			}

			prepareCsrfToken({
				success: function () {
					authorize(username, password, domainId);
				},
				failure: function (response) {
					if (response.status == 0) {
						messageTarget.update(PW.t('Brak_polaczenia_z_serwerem'));
					} else if (response.isTimeout) {
						messageTarget.update(PW.t('Przekroczono czas oczekiwania na odpowiedź serwera'));
					} else {
						messageTarget.update(PW.t('unkownErrorText'));
					}

					messageTarget.removeClass('hide')
					loginMask.hide();
				}
			});

			return false;
		}

		function authorize(username, password, domainId) {
			var params = {
				username: username,
				password: password,
				domainId: domainId
			};

			if (requireCaptcha) {
				params.captchaId = captchaId;
				params.captcha = Ext.get('captcha').dom.value;
			}

			Ext.Ajax.request({
				url: Suncode.getAbsolutePath('com.plusmpm.servlet.authorization.UserAuthorizationServlet.customServlet'),
				params: params,
				success: function (request) {
					var data = Ext.util.JSON.decode(request.responseText);
					document.querySelector("#login-csrf-input")
							.setAttribute("value", Suncode.getCsrfToken());
					processResponse(data);
				},
				failure: function (response) {
					if(response.status == 0) {
						messageTarget.update(PW.t('Brak_polaczenia_z_serwerem'));
					}
					else if(response.isTimeout) {
						messageTarget.update(PW.t('Przekroczono czas oczekiwania na odpowiedź serwera'));
					}
					else {
						messageTarget.update(PW.t('Podano_nieprawidlowe_dane_do_logowania_sprobuj_ponownie'));
					}

					messageTarget.removeClass('hide')
					loginMask.hide();
				},
			});
		}

		function processResponse(data) {
			if (data.success) {
				if (data.license == false) {
					var redirectUrl = Ext.get("redirectUrl");
					redirectUrl.set({
						value: '/License.do'
					});
				}
				if (data.ldapError === 'LDAP_PASSWORD_EXPIRES_SOON'){
					Ext.Msg.confirm('', PW.t('Ldap_password_change_prompt'), function(btn){
						if(btn == 'yes'){
								location.href = Suncode.getContextPath() + '/LdapChangePassword.do';
						}else{
							document.forms["loginForm"].submit();
						}
					});
					return false;
				}
				document.forms["loginForm"].submit();
			}
			else {
				if (data.license == false) {
					messageTarget.update(data.msg);
				}
				else if (data.incorrectCaptcha) {
					messageTarget.update(PW.t('Kod_z_obrazka_jest_nieprawidlowy'));
				}
				else if (data.userBlocked) {
					messageTarget.update(PW.t('Uzytkownik_zostal_zablokowany_przez_administratora'));
				}
				else if (data.weakPassword) {
					messageTarget.update(PW.t('Haslo_nie_spelnia_wymogow_bezpieczenstwa'));
					setTimeout(function () {
						window.location.href = Suncode.getContextPath() + '/ChangePassword.do';
					}, 1500);
				}
				else if (data.expiredPassword) {
					messageTarget.update(PW.t('Obecne_haslo_stracilo_waznosc'));
					setTimeout(function () {
						window.location.href = Suncode.getContextPath() + '/ChangePassword.do';
					}, 1500);
				}
				else if (data.passwordChangeRequired) {
					messageTarget.update(PW.t('Wymagana_zmiana_hasla_pierwsze_logowanie'));
					setTimeout(function () {
						window.location.href = Suncode.getContextPath() + '/ChangePassword.do';
					}, 1500);
				}
				else if (data.maintenanceModeDeny) {
					messageTarget.update(PW.t('logging_in_blocked_due_maintenance'));
				}
				else {
					messageTarget.update(data.msg || PW.t('Podano_nieprawidlowe_dane_do_logowania_sprobuj_ponownie'));
				}

				requireCaptcha = data.requireCaptcha;
				if (requireCaptcha) {
					showCaptchaField();
				}
				else {
					jQuery('#captcha-container').hide();
				}

				messageTarget.removeClass('hide');
				loginMask.hide();
			}
		}

		function generateUuid() {
			return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
				var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
				return v.toString(16);
			});
		}

		window.doLogin = doLogin;
		window.doAutoLogin = doAutoLogin;
		window.showCaptchaField = showCaptchaField;

		<%
			String sessionMessage = (String)session.getAttribute( "message" );
			if(sessionMessage != null) {
			%>
				var sessionMessage = '<%=session.getAttribute( "message" )%>';
				var sessionMessageSuccess = JSON.parse('<%=session.getAttribute( "messageSuccess" )%>');

				if(sessionMessageSuccess) {
					PW.ui.Message.success(sessionMessage);
				}
				else {
					PW.ui.Message.error(sessionMessage);
				}
			<%
			}

			session.removeAttribute( "message" );
			session.removeAttribute( "messageSuccess" );
		%>

		var externalAuthorizationResult = JSON.parse('<%=request.getAttribute("externalAuthorizationResult")%>');
		if( externalAuthorizationResult ) {
		    processResponse( externalAuthorizationResult );
		}
	})();
</script>