<%@page import="java.text.SimpleDateFormat"%>
<%@page import="java.text.DateFormat"%>
<%@page import="com.plusmpm.database.files.ExtendedDocumentData"%>
<%@page import="com.plusmpm.database.files.FileVersions"%>
<%@page import="com.plusmpm.util.Tools"%>
<%@page import="org.apache.commons.lang.StringEscapeUtils"%>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@page language="Java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<bean:define id="n_a"><bean:message key="n_a"/></bean:define>
<bean:define id="Ukryj_indeksy"><bean:message key="Ukryj_indeksy"/></bean:define>
<bean:define id="Pokaz_indeksy"><bean:message key="Pokaz_indeksy"/></bean:define>
<bean:define id="Pokaz_wszystkie_wersje"><bean:message key="Pokaz_wszystkie_wersje"/></bean:define>
<bean:define id="Ukryj"><bean:message key="Ukryj"/></bean:define>


<div>
	<%
	    ExtendedDocumentData documentData = (ExtendedDocumentData) request.getAttribute( "documentData" );
	    Long documentId = documentData.getLDocumentId();
	    String docClassName = StringEscapeUtils.escapeXml(documentData.getLDocClassName());
	    String documentDate = documentData.getSDocumentDate();
	    String expirationDate = documentData.getSExpiretionDate();
	    String owner = documentData.getOwner();
	    String description =  StringEscapeUtils.escapeHtml(documentData.getDescription());
	    String fileSizeKbytes = String.format( "%.1f", documentData.getSize() / 1024F );
	    Long version = documentData.getFileVersions().getVersion();
	    String state = documentData.getState();
	    String comment = StringEscapeUtils.escapeHtml(documentData.getFileVersions().getComment() );

	    /* Dodatkowe zmiany */
	    if(expirationDate == null || expirationDate.equals( "" ))
	    {
	        expirationDate = n_a;
	    }

	    String documentLinkTemplate = (String) request.getAttribute("documentLinkTemplate");
	    String documentLink = documentLinkTemplate + Tools.encodeStringBase64( String.valueOf(documentData.getLFileId()) );
	    String showDocumentLink = "javascript:Viewer('" + documentLink +"',false)";
	    /* stan dokumentu i to co sie z nim wiaze -- jesli edit, to takze info o tym przez kogo i kiedy */

	    String checkOutState = documentData.getFileVersions().getState();
	    String checkOutUser = null;
	    String checkOutDate = null;
	    Boolean showStateInfo = false;
	    if ( ( checkOutState != null ) && ( checkOutState.equals( FileVersions.State.STATE_EDIT.toString() ) ) )
	    {
	        showStateInfo = true;
	        checkOutUser = documentData.getFileVersions().getCheckout_user();
	        checkOutDate = documentData.getFileVersions().getCheckout_date().toString();
	    }
	%>
	<table id="documentInformationTable" class="document-information-table">
		<tbody>
			<tr>
				<td class="document-information-label"><bean:message key="Id_dokumentu"/>:</td>
				<td class="document-information-value"><%=documentId%>
				</td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Klasa_dokumentow"/>:</td>
				<td class="document-information-value"><%=docClassName%></td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Link_do_dokumentu"/>:</td>
				<td class="document-information-value"><a href="<%=showDocumentLink%>"><bean:message key="Pokaz_dokument"/></a> /
				<a id="documentLink" href="<%=documentLink%>">Link</a></td>

			</tr>

			<c:if test="${!empty indices}">
				<tr><td class="document-information-label"><bean:message key="Indeksy"/>:</td><td class="document-information-value"><a href="javascript://nope" id="showHideIndexesLink"><%=Pokaz_indeksy %></a></td></tr>
				<c:forEach var="index" items="${indices}">
					<tr class="document-information-index">
						<td class="document-information-label document-information-small">
							<c:out value="${index.name}"/>
						</td>
						<td class="document-information-value document-information-small">
							<c:choose>
								<c:when test="${empty index.value }">
									<span  class="document-information-index-empty"><bean:message key="none"/></span>
								</c:when>
								<c:otherwise>
									<c:out value="${index.value}"/>
								</c:otherwise>
							</c:choose>
						</td>
					</tr>
				</c:forEach>
			</c:if>

			<tr>
				<td class="document-information-label"><bean:message key="Data_archiwizacji"/>:</td>
				<td class="document-information-value"><%=documentDate%></td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Data_wygasniecia"/>:</td>
				<td class="document-information-value"><%=expirationDate%></td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Wlasciciel"/>:</td>
				<td class="document-information-value"><%=owner%></td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Opis"/>:</td>
				<td class="document-information-value"><%=description%></td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Rozmiar"/>:</td>
				<td class="document-information-value"><%=fileSizeKbytes%> KB</td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Wersja"/>:</td>
				<td class="document-information-value"><%=version%><c:if test="${!empty versions }"> <a href="javascript://nope" id="showHideVersionsLink" ><%=Pokaz_wszystkie_wersje%></a></c:if></td>
			</tr>

			<c:if test="${!empty versions }">
				<c:forEach var="version" items="${versions}">
				<%
					FileVersions fVers = (FileVersions)pageContext.getAttribute("version");
					String versionLink = "javascript:Viewer('" + documentLinkTemplate + Tools.encodeStringBase64( fVers.getFileid().toString() ) +"',false)";
				%>
					<tr class="document-version-row">
					<td class="document-information-label document-information-small">
						<bean:message key="Wersja"/> <c:out value="${version.version}"/>
					</td>
					<td class="document-information-value document-information-small"><a href="<%=versionLink%>"><bean:message key="Pokaz_dokument"/></a></td>
					</tr>
				</c:forEach>

			</c:if>

			<tr>
				<td class="document-information-label"><bean:message key="Stan"/>:</td>
				<td class="document-information-value"><%=state%></td>
			</tr>
			<%
			    if ( showStateInfo == true )
			    {
			%>

			<tr>
				<td class="document-information-label"><bean:message key="Uzytkownik_ktory_pobieral_do_zmiany"/>:</td>
				<td class="document-information-value"><%=checkOutUser%></td>
			</tr>
			<tr>
				<td class="document-information-label"><bean:message key="Data_pobrania_do_zmiany"/>:</td>
				<td class="document-information-value"><%=checkOutDate%></td>
			</tr>

			<%
			    }
			%>
			<tr>
				<td class="document-information-label"><bean:message key="Komentarz"/>:</td>
				<td class="document-information-value"><%=comment%></td>
			</tr>

		</tbody>
	</table>
</div>

<script type="text/javascript">
	function Viewer( text ) {
	    var text2 = 'menubar=no,toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=yes,fullscreen=no,channelmode=no,width='
	                    + screen.width / 2 + ',height=' + screen.height + ',left=' + screen.width / 2 + ',top=0';
	    window.open( text, 'viewer', text2 ).focus();
	}

(function(){
	var versionRows, indicesRows;

    function onVersionsToggleEventHandler(button){
		if(versionRows.first().isDisplayed()){
			versionRows.setDisplayed(false);
			button.update("<%=Pokaz_wszystkie_wersje%>");
		}
		else{
			versionRows.setDisplayed(true);
			button.update("<%=Ukryj%>");
		}
	}

	function onIndicesToggleEventHandler(button){
		if(indicesRows.first().isDisplayed()){
			indicesRows.setDisplayed(false);
			button.update("<%=Pokaz_indeksy%>");
		}
		else {
			indicesRows.setDisplayed(true);
			button.update("<%=Ukryj_indeksy%>");
		}
	}

    versionRows = Ext.select( ".document-version-row", true, "documentInformationTable" );
    if ( versionRows.getCount() > 0 ) {
        versionRows.setDisplayed( false );

        Ext.get( "showHideVersionsLink" ).on( "click", function() {
            onVersionsToggleEventHandler( this );
        } );
    }

    indicesRows = Ext.select( ".document-information-index", true, "documentInformationTable" );
    if ( indicesRows.getCount() > 0 ) {
        indicesRows.setDisplayed( false );

        Ext.get( "showHideIndexesLink" ).on( "click", function() {
            onIndicesToggleEventHandler( this );
        } );
    }
} )();
</script>