<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>  

<%@page language="Java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<div class="content-header">
	<p>
		<bean:message key="Podstawowe_informacje" />
	</p>
</div>
<table class="form-table">
	<tr>
		<td><bean:message key="Nazwa_domeny" /></td>
		<td><input type="text" name="domainName" id="domain"
			value="${fn:escapeXml(domainForm.domainName)}" /></td>
	</tr>
	<tr>
		<td><bean:message key="Adres_serwera" /></td>
		<td><input type="text" name="domainServer" id="domainServer"
			value="${fn:escapeXml(domainForm.domainServer)}" /></td>
	</tr>
	<tr>
		<td><bean:message key="Numer_portu_serwera" /></td>
		<td><input type="text" name="domainServerPort"
			id="domainServerPort" value="${domainForm.domainServerPort}" /></td>
	</tr>
	<tr>
		<td><bean:message key="LDAP_over_SSL" /></td>
		<td><input type="checkbox" name="ldapOverSsl" onchange="saveValue('ldapOverSsl', 'check')"
		 id="ldapOverSsl"  value="<c:out value="${domainForm.ldapOverSsl}"/>"
		 <c:if test="${domainForm.ldapOverSsl}">checked</c:if>
		 /></td>
	</tr>
    <tr>
        <td><bean:message key="LDAP_START_TLS" /></td>
        <td><input type="checkbox" name="startTLS" onchange="saveValue('startTLS', 'check')"
         id="startTLS"  value="<c:out value="${domainForm.startTLS}"/>"
         <c:if test="${domainForm.startTLS}">checked</c:if>
        /></td>
    </tr>
	<tr>
		<td><bean:message key="Uzytkownik" /></td>
		<td><input type="text" name="domainUser" id="domainUser"
			value="${fn:escapeXml(domainForm.domainUser)}" /></td>
	</tr>
	<tr>
		<td><bean:message key="Haslo" /></td>
		<td><input type="password" name="domainUserPassword"
			id="domainUserPassword" autocomplete="new-password"/></td>
	</tr>
	<tr>
		<td><bean:message key="Potwierdzenie_hasla" /></td>
		<td><input type="password" name="domainConfUserPassword"
			id="domainConfUserPassword" autocomplete="new-password"/></td>
	</tr>
	<tr>
		<td><bean:message key="Parametry_polaczenia" /></td>
		<td><input type="text" name="domainBaseSearch"
			id="domainBaseSearch" value="${fn:escapeXml(domainForm.domainBaseSearch)}" /></td>
	</tr>
	<tr>
		<td><bean:message key="Szablon_nazwy_uzytkownika" /></td>
		<td><input type="text" name="usernameTemplate"
			id="usernameTemplate" value="${domainForm.usernameTemplate}" /></td>
	</tr>
	<tr>
		<td><bean:message key="Domena_SPNEGO" /></td>
		<td><input type="text" name="domainSpnego" id="domainSpnego"
			value="${fn:escapeXml(domainForm.domainSpnego)}" /></td>
	</tr>
</table>
<div class="content-header">
	<p>
		<bean:message key="Mapowanie_atrybutow_LDAP" />
	</p>
</div>
<table class="form-table">
	<tr>
		<td><bean:message key="Nazwa_uzytkownika" /></td>
		<td><input id=usernameMapping name="usernameMapping" type="text"
			value="${domainForm.usernameMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="Imie" /></td>
		<td><input id=firstnameMapping name="firstnameMapping"
			type="text" value="${domainForm.firstnameMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="Nazwisko" /></td>
		<td><input id=lastnameMapping name="lastnameMapping" type="text"
			value="${domainForm.lastnameMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="Email" /></td>
		<td><input id=emailMapping name="emailMapping" type="text"
			value="${domainForm.emailMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="Uzytkownicy_nalezacy_do_grupy" /></td>
		<td><input id=memberMapping name="memberMapping" type="text"
			value="${domainForm.memberMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="Grupy_do_ktorych_nalezy_uzytkownik" /></td>
		<td><input id=memberOfMapping name="memberOfMapping" type="text"
			value="${domainForm.memberOfMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="Numer" /></td>
		<td><input id=numberMapping name="numberMapping" type="text"
			value="${domainForm.numberMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="User_Attribute" /></td>
		<td><input id=userAttributeMapping name="userAttributeMapping" type="text"
				   value="${domainForm.userAttributeMapping}"></td>
	</tr>
	<tr>
		<td><bean:message key="Group_Attribute" /></td>
		<td><input id=groupAttributeMapping name="groupAttributeMapping" type="text"
				   value="${domainForm.groupAttributeMapping}"></td>
	</tr>
</table>