/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.search;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemPropertiesBean;
import com.suncode.pwfl.form.service.FormService;
import com.suncode.pwfl.form.util.enumeration.ActionAcceptButtonDestination;
import com.suncode.pwfl.form.util.enumeration.XpdlExtendedAttribute;
import com.suncode.pwfl.form.util.object.ActivityForm;
import com.suncode.pwfl.form.util.object.builder.ActivityFormBuilder;
import com.suncode.pwfl.form.validator.ActivityFormValidator;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.web.controller.api.workflow.search.cache.SearchResultMeta;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.form.validator.ValidationErrorsResolver;
import com.suncode.pwfl.workflow.form.validator.ValidationMetadata;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import com.suncode.pwfl.xpdl.table.Column;
import com.suncode.pwfl.xpdl.table.Table;
import com.suncode.pwfl.xpdl.table.XpdlTableService;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Validator;

@Component
public class AdvanceProcessSearchValidationHelper {
    private static final Logger log = LoggerFactory.getLogger(AdvanceProcessSearchValidationHelper.class);
    private final SystemPropertiesBean systemProperties;
    private final ActivityService activityService;
    private final ActivityFormBuilder activityFormBuilder;
    private final ActivityFormValidator activityFormValidator;
    private final FormService formService;
    private final ValidationErrorsResolver validationErrorsResolver;
    private final XpdlTableService xpdlTableService;
    private final TransactionWrapper transactionWrapper;
    private final VariableFactory variableFactory;

    public List<SearchResultMeta> performActivityValidation(String actionName, List<SearchResultMeta> searchResultMetas, String userName) {
        if (this.isValidationDisabled()) {
            return searchResultMetas;
        }
        ArrayList<SearchResultMeta> validatedResults = new ArrayList<SearchResultMeta>();
        for (SearchResultMeta searchResultMeta : searchResultMetas) {
            if (!this.isActivityValid(searchResultMeta, actionName, userName)) continue;
            validatedResults.add(searchResultMeta);
        }
        return validatedResults;
    }

    private boolean isValidationDisabled() {
        return this.systemProperties.getBoolean(DefinedSystemParameter.DISABLE_GROUP_ACCEPTANCE_VALIDATION);
    }

    private boolean isActivityValid(SearchResultMeta searchResultMeta, String actionName, String userName) {
        return (Boolean)this.transactionWrapper.doInSharkTransaction(transaction -> this.validateActivityInTransaction(searchResultMeta, actionName, userName, transaction));
    }

    private boolean validateActivityInTransaction(SearchResultMeta searchResultMeta, String actionName, String userName, SharkTransaction sharkTransaction) {
        String processId = searchResultMeta.getProcessId();
        String activityId = searchResultMeta.getActivityId();
        if (StringUtils.isNotEmpty((CharSequence)actionName) && !this.actionNameExistsAndVisible(processId, activityId, actionName, sharkTransaction)) {
            return false;
        }
        Map activityContext = this.activityService.getActivityContext(processId, activityId);
        ActivityForm activityForm = this.buildActivityForm(processId, activityId, userName, activityContext, actionName, sharkTransaction);
        BindingResult bindingResult = this.validateActivityForm(activityForm);
        ValidationErrors validationErrors = this.validateActivity(processId, activityId, actionName, activityContext, sharkTransaction);
        return this.isValidationSuccessful(bindingResult, validationErrors);
    }

    private ActivityForm buildActivityForm(String processId, String activityId, String userName, Map<String, Object> activityContext, String actionName, SharkTransaction sharkTransaction) {
        Locale locale = LocaleContextHolder.getLocale();
        boolean checkForm = this.resolveCheckFormForAction(processId, activityId, actionName, sharkTransaction);
        Map<String, String[]> variables = this.buildVariables(activityContext);
        ActivityForm activityForm = this.activityFormBuilder.build(processId, activityId, userName, variables, checkForm, locale);
        List tables = this.xpdlTableService.getHeuristicGlobalTablesForActivity(activityForm.getProcessDefId(), activityForm.getActivityDefId(), LocaleContextHolder.getLocale());
        Map<String, String[]> variableSetsSizes = this.buildVariableSetsSizes(tables, variables);
        activityForm.setValidators(this.formService.buildValidators(Boolean.valueOf(checkForm)));
        activityForm.setVariableSetsSizes(variableSetsSizes);
        activityForm.resolveVariables(this.variableFactory);
        return activityForm;
    }

    private boolean resolveCheckFormForAction(String processId, String activityId, String actionName, SharkTransaction sharkTransaction) {
        return this.findActionNameInfo(processId, activityId, actionName, sharkTransaction).checkForm();
    }

    private boolean actionNameExistsAndVisible(String processId, String activityId, String actionName, SharkTransaction sharkTransaction) {
        ActionInfo actionInfo = this.findActionNameInfo(processId, activityId, actionName, sharkTransaction);
        String destination = actionInfo.destination();
        boolean isVisible = destination == null || destination.equals(ActionAcceptButtonDestination.ALL.name()) || destination.equals(ActionAcceptButtonDestination.GROUPFORM.name());
        return actionInfo.exists() && isVisible;
    }

    private ActionInfo findActionNameInfo(String processId, String activityId, String actionName, SharkTransaction sharkTransaction) {
        try {
            String[][] extAttrs;
            for (String[] extAttr : extAttrs = Shark.getInstance().getAdminInterface().getAdminMisc().getActivitiesExtendedAttributeNameValuePairs(sharkTransaction, processId, activityId)) {
                ActionInfo attributes;
                if (!XpdlExtendedAttribute.ACTION_ACCEPT_BUTTON.name().equalsIgnoreCase(extAttr[0]) || !Objects.equals(actionName, (attributes = this.parseActionAttributes(extAttr[1])).actionName())) continue;
                return new ActionInfo(attributes.actionName(), true, attributes.checkForm(), attributes.destination());
            }
        }
        catch (Exception e) {
            log.warn("Failed to find actionName info for action: " + actionName, (Throwable)e);
        }
        return new ActionInfo(null, false, false, null);
    }

    private ActionInfo parseActionAttributes(String attributeValue) {
        String actionName = null;
        boolean checkForm = false;
        String destination = null;
        for (String line : attributeValue.split("\n")) {
            String[] parts = line.split("=", 2);
            if (parts.length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            if ("actionName".equalsIgnoreCase(key)) {
                actionName = value;
                continue;
            }
            if ("checkForm".equalsIgnoreCase(key)) {
                checkForm = Boolean.parseBoolean(value);
                continue;
            }
            if (!"destination".equalsIgnoreCase(key)) continue;
            destination = value;
        }
        return new ActionInfo(actionName, actionName != null, checkForm, destination);
    }

    private BindingResult validateActivityForm(ActivityForm activityForm) {
        if (activityForm.getValidators() == null) {
            return null;
        }
        DataBinder binder = new DataBinder((Object)activityForm);
        binder.setValidator((Validator)this.activityFormValidator);
        binder.validate();
        return binder.getBindingResult();
    }

    private ValidationErrors validateActivity(String processId, String activityId, String actionName, Map<String, Object> activityContext, SharkTransaction sharkTransaction) {
        ValidationMetadata validationMetadata = ValidationMetadata.builder().processId(processId).activityId(activityId).actionName(actionName).activityContext(activityContext).build();
        return this.validationErrorsResolver.validate(sharkTransaction, validationMetadata);
    }

    private boolean isValidationSuccessful(BindingResult bindingResult, ValidationErrors validationErrors) {
        boolean noBindingErrors = bindingResult == null || !bindingResult.hasErrors();
        boolean noValidationErrors = validationErrors.areEmpty();
        boolean noCallbackValidators = validationErrors.getInvokedCallbackValidators().isEmpty();
        return noBindingErrors && noValidationErrors && noCallbackValidators;
    }

    private Map<String, String[]> buildVariables(Map<String, Object> contextMap) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String[]> variables = new HashMap<String, String[]>();
        contextMap.forEach((key, value) -> {
            String formattedValue = this.formatValue(value, dateFormat);
            variables.put((String)key, new String[]{formattedValue});
        });
        return variables;
    }

    private String formatValue(Object value, SimpleDateFormat dateFormat) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return dateFormat.format(date);
        }
        return value.toString();
    }

    private Map<String, String[]> buildVariableSetsSizes(List<Table> tables, Map<String, String[]> variables) {
        HashMap<String, String[]> variableSetsSizes = new HashMap<String, String[]>();
        if (tables == null || tables.isEmpty()) {
            return variableSetsSizes;
        }
        for (int tableIndex = 0; tableIndex < tables.size(); ++tableIndex) {
            Table table = tables.get(tableIndex);
            int rowCount = this.calculateTableRowCount(table, variables);
            String variableSetKey = "variable_set_" + tableIndex;
            variableSetsSizes.put(variableSetKey, new String[]{String.valueOf(rowCount)});
        }
        return variableSetsSizes;
    }

    private int calculateTableRowCount(Table table, Map<String, String[]> variables) {
        if (table.getColumns() == null || table.getColumns().isEmpty()) {
            return 0;
        }
        String firstColumnVarId = ((Column)table.getColumns().get(0)).getVarId();
        if (!variables.containsKey(firstColumnVarId)) {
            return 0;
        }
        String[] columnValues = variables.get(firstColumnVarId);
        if (columnValues == null || columnValues.length == 0) {
            return 0;
        }
        if (columnValues.length == 1) {
            boolean allColumnsEmpty = table.getColumns().stream().map(column -> (String[])variables.get(column.getVarId())).filter(values -> values != null && ((String[])values).length > 0).allMatch(values -> values[0] == null || values[0].trim().isEmpty());
            return allColumnsEmpty ? 0 : 1;
        }
        return columnValues.length;
    }

    @ConstructorProperties(value={"systemProperties", "activityService", "activityFormBuilder", "activityFormValidator", "formService", "validationErrorsResolver", "xpdlTableService", "transactionWrapper", "variableFactory"})
    @Autowired
    public AdvanceProcessSearchValidationHelper(SystemPropertiesBean systemProperties, ActivityService activityService, ActivityFormBuilder activityFormBuilder, ActivityFormValidator activityFormValidator, FormService formService, ValidationErrorsResolver validationErrorsResolver, XpdlTableService xpdlTableService, TransactionWrapper transactionWrapper, VariableFactory variableFactory) {
        this.systemProperties = systemProperties;
        this.activityService = activityService;
        this.activityFormBuilder = activityFormBuilder;
        this.activityFormValidator = activityFormValidator;
        this.formService = formService;
        this.validationErrorsResolver = validationErrorsResolver;
        this.xpdlTableService = xpdlTableService;
        this.transactionWrapper = transactionWrapper;
        this.variableFactory = variableFactory;
    }

    private record ActionInfo(String actionName, boolean exists, boolean checkForm, String destination) {
    }
}

