/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity;

import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.workflow.activity.internal.ActivityAssignmentsService;
import com.suncode.pwfl.workflow.activity.internal.dto.ActivityAssignmentDto;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/activity/assignments"})
public class ActivityAssignmentsController {
    private final ActivityAssignmentsService activityAssignmentsService;
    private final AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public CountedResult<ActivityAssignmentDto> getActivityAssignments(@RequestParam String processId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        return (CountedResult)this.authorizationHelper.ensureProcessAccess(processId, null, () -> {
            List activityAssignmentDtos = this.activityAssignmentsService.getActivityAssignments(processId, false);
            activityAssignmentDtos.sort(DtoComparator.of(ActivityAssignmentDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true));
            return Paginator.forAll((List)activityAssignmentDtos).viewPageByOffset(start, limit);
        }).getBody();
    }

    @ConstructorProperties(value={"activityAssignmentsService", "authorizationHelper"})
    @Autowired
    public ActivityAssignmentsController(ActivityAssignmentsService activityAssignmentsService, AuthorizationHelper authorizationHelper) {
        this.activityAssignmentsService = activityAssignmentsService;
        this.authorizationHelper = authorizationHelper;
    }
}

