/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.processHeaderField;

import com.suncode.pwfl.administration.processHeaderField.DefaultProcessHeaderFieldsStatus;
import com.suncode.pwfl.administration.processHeaderField.ProcessHeaderField;
import com.suncode.pwfl.administration.processHeaderField.ProcessHeaderFieldService;
import com.suncode.pwfl.administration.processHeaderField.ProcessHeaderFieldType;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.view.exception.NoPermissionToProcessException;
import com.suncode.pwfl.web.dto.administration.processHeaderField.ProcessHeaderFieldDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processHeaderFields"})
@Api(hidden=true)
public class ProcessHeaderFieldController {
    private static final Logger log = LoggerFactory.getLogger(ProcessHeaderFieldController.class);
    private final ProcessHeaderFieldService processHeaderFieldService;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;

    @GetMapping(value={"types"})
    @ResponseBody
    public List<ProcessHeaderFieldType> getTypes() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.processHeaderFieldService.getProcessHeaderFieldTypes();
    }

    @GetMapping
    @ResponseBody
    public List<ProcessHeaderFieldDto> getProcessHeaderFieldsForProcessDefinitionId(@RequestParam String processDefId) throws NoPermissionToProcessException {
        if (!this.authorizationHelper.hasSearchProcessAccess(processDefId).booleanValue()) {
            throw new NoPermissionToProcessException(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        }
        return this.getProcessHeaderFieldsDto(processDefId);
    }

    @GetMapping(value={"administration"})
    @ResponseBody
    public List<ProcessHeaderFieldDto> getProcessHeaderFieldsForAdministration(@RequestParam String processDefId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.getProcessHeaderFieldsDto(processDefId);
    }

    private List<ProcessHeaderFieldDto> getProcessHeaderFieldsDto(String processDefId) {
        return this.processHeaderFieldService.getProcessHeaderFields(processDefId).stream().map(ProcessHeaderFieldDto::toDto).sorted(Comparator.comparing(ProcessHeaderFieldDto::getPosition, Comparator.nullsLast(Comparator.naturalOrder()))).toList();
    }

    @PostMapping
    @ResponseBody
    public DefaultProcessHeaderFieldsStatus saveProcesHeaderFields(HttpServletRequest request, @RequestBody List<ProcessHeaderFieldDto> processHeaderFieldDtos, @RequestParam String processDefId) {
        DefaultProcessHeaderFieldsStatus fields;
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CHANGE_SELECTED_PROCESS_HEADER_FIELDS);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        List<ProcessHeaderField> processHeaderFields = processHeaderFieldDtos.stream().map(ProcessHeaderFieldDto::toEntity).toList();
        try {
            fields = this.processHeaderFieldService.saveProcessHeaderFields(processHeaderFields, processDefId);
            String savedFieldsIds = fields.getSavedFields().stream().map(processHeaderField -> this.messageHelper.getMessage("PROCESS_HEADER_FIELD_TYPE_" + String.valueOf(processHeaderField.getType()))).collect(Collectors.joining(", "));
            String updatedFieldsIds = fields.getUpdatedFields().stream().map(processHeaderField -> this.messageHelper.getMessage("PROCESS_HEADER_FIELD_TYPE_" + String.valueOf(processHeaderField.getType()))).collect(Collectors.joining(", "));
            String deletedFieldsIds = fields.getDeletedFields().stream().map(processHeaderField -> this.messageHelper.getMessage("PROCESS_HEADER_FIELD_TYPE_" + String.valueOf(processHeaderField.getType()))).collect(Collectors.joining(", "));
            HashMap<String, String> auditParams = new HashMap<String, String>();
            auditParams.put("saved", savedFieldsIds);
            auditParams.put("updated", updatedFieldsIds);
            auditParams.put("deleted", deletedFieldsIds);
            auditParams.put("processDefId", processDefId);
            auditBuilder.params(auditParams).buildSuccess(request);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        return fields;
    }

    @ExceptionHandler(value={NotFullRightsException.class, NoPermissionToProcessException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoRightsException(Exception e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"processHeaderFieldService", "messageHelper", "authorizationHelper"})
    @Autowired
    public ProcessHeaderFieldController(ProcessHeaderFieldService processHeaderFieldService, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper) {
        this.processHeaderFieldService = processHeaderFieldService;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
    }
}

