/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.authentication.microsoftGraphApi;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthentication;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthenticationException;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthenticationService;
import com.suncode.pwfl.administration.authentication.microsoftGraphApi.MicrosoftGraphApiConnectionResult;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.web.dto.administration.authentication.microsoftGraphApi.MicrosoftGraphApiAuthenticationDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/authenticationManagement/microsoftGraphApi"})
public class MicrosoftGraphApiAuthenticationController {
    private static final Logger log = LoggerFactory.getLogger(MicrosoftGraphApiAuthenticationController.class);
    private final MicrosoftGraphApiAuthenticationService microsoftGraphApiAuthenticationService;
    private final AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    private List<MicrosoftGraphApiAuthenticationDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.microsoftGraphApiAuthenticationService.getAll(new String[0]).stream().map(MicrosoftGraphApiAuthenticationDto::new).sorted((Comparator<MicrosoftGraphApiAuthenticationDto>)DtoComparator.of(MicrosoftGraphApiAuthenticationDto.class, (String)"name", (SortDirection)SortDirection.ASC).withIgnoreCase(true)).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"getOauthUrl"})
    private String getOauthUrl(@RequestBody MicrosoftGraphApiAuthenticationDto configurationDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        MicrosoftGraphApiAuthentication configuration = configurationDto.toEntity();
        return this.microsoftGraphApiAuthenticationService.getOauthUrl(configuration);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"test"})
    private MicrosoftGraphApiConnectionResult testConnection(@RequestBody MicrosoftGraphApiAuthenticationDto configurationDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        MicrosoftGraphApiAuthentication configuration = configurationDto.toEntity();
        return this.microsoftGraphApiAuthenticationService.testConnection(configuration);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"connect"})
    private MicrosoftGraphApiConnectionResult connect(@RequestBody MicrosoftGraphApiAuthenticationDto configurationDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        MicrosoftGraphApiAuthentication configuration = configurationDto.toEntity();
        return this.microsoftGraphApiAuthenticationService.connect(configuration);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    private MicrosoftGraphApiAuthenticationDto getById(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        MicrosoftGraphApiAuthentication config = (MicrosoftGraphApiAuthentication)this.microsoftGraphApiAuthenticationService.get((Serializable)((Object)id));
        return new MicrosoftGraphApiAuthenticationDto(config);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    private MicrosoftGraphApiAuthenticationDto create(@RequestBody MicrosoftGraphApiAuthenticationDto newConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_MICROSOFT_GRAPH_API_AUTHENTICATION).params(this.getAuditParams(newConfigurationDto));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            MicrosoftGraphApiAuthentication newConfiguration = newConfigurationDto.toEntity();
            this.microsoftGraphApiAuthenticationService.save((Object)newConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new MicrosoftGraphApiAuthenticationDto(newConfiguration);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.PATCH})
    private MicrosoftGraphApiAuthenticationDto update(@RequestBody MicrosoftGraphApiAuthenticationDto configurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_MICROSOFT_GRAPH_API_AUTHENTICATION);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", Objects.toString(configurationDto.getId(), ""));
        auditBuilder.params(params);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            MicrosoftGraphApiAuthentication oldConfiguration = (MicrosoftGraphApiAuthentication)this.microsoftGraphApiAuthenticationService.get((Serializable)((Object)configurationDto.getId()));
            MicrosoftGraphApiAuthentication newConfiguration = configurationDto.toEntity();
            params.putAll(this.getUpdateAuditParams(oldConfiguration, newConfiguration));
            auditBuilder.params(params);
            this.microsoftGraphApiAuthenticationService.update((Object)newConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new MicrosoftGraphApiAuthenticationDto(newConfiguration);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    private void delete(@PathVariable String id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_MICROSOFT_GRAPH_API_AUTHENTICATION).params((Map)ImmutableMap.of((Object)"id", (Object)id));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            MicrosoftGraphApiAuthentication config = (MicrosoftGraphApiAuthentication)this.microsoftGraphApiAuthenticationService.get((Serializable)((Object)id));
            this.microsoftGraphApiAuthenticationService.delete((Object)config);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ExceptionHandler(value={MicrosoftGraphApiAuthenticationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleConfigurationException(MicrosoftGraphApiAuthenticationException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    private Map<String, Object> getAuditParams(MicrosoftGraphApiAuthenticationDto configDto) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", Objects.toString(configDto.getId(), ""));
        params.put("name", Objects.toString(configDto.getName(), ""));
        return params;
    }

    private Map<String, Object> getUpdateAuditParams(MicrosoftGraphApiAuthentication oldConfiguration, MicrosoftGraphApiAuthentication newConfiguration) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", this.getChangeString(oldConfiguration, newConfiguration, MicrosoftGraphApiAuthentication::getName));
        return params;
    }

    private String getChangeString(MicrosoftGraphApiAuthentication oldConfiguration, MicrosoftGraphApiAuthentication newConfiguration, Function<MicrosoftGraphApiAuthentication, Object> valueFunction) {
        String oldValue = Objects.toString(valueFunction.apply(oldConfiguration), "");
        String newValue = Objects.toString(valueFunction.apply(newConfiguration), "");
        return String.format("%s;%s", oldValue, newValue);
    }

    @ConstructorProperties(value={"microsoftGraphApiAuthenticationService", "authorizationHelper"})
    @Autowired
    public MicrosoftGraphApiAuthenticationController(MicrosoftGraphApiAuthenticationService microsoftGraphApiAuthenticationService, AuthorizationHelper authorizationHelper) {
        this.microsoftGraphApiAuthenticationService = microsoftGraphApiAuthenticationService;
        this.authorizationHelper = authorizationHelper;
    }
}

