/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.servlet;

import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.simulation.SimulationService;
import com.suncode.pwfl.workflow.simulation.delegated.SimulationProxy;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.util.UrlPathHelper;

public class SimulationServlet
extends HttpServlet {
    private static final String SIMULATION_PATH_PREFIX = "/simulation";
    private final UrlPathHelper pathHelper = new UrlPathHelper();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleService(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleService(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleService(req, resp);
    }

    protected void handleService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SimulationService simulationService = (SimulationService)SpringContext.getBean(SimulationService.class);
        String simulationId = this.getSimulationId(req, resp);
        SimulationProxy simulation = (SimulationProxy)simulationService.findActiveById(simulationId).orElseThrow();
        simulation.getContext().getDispatcherServlet().service((ServletRequest)req, (ServletResponse)resp);
    }

    private String getSimulationId(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String path = this.pathHelper.getPathWithinApplication(request).substring(SIMULATION_PATH_PREFIX.length() + 1);
            return path.indexOf(47) > -1 ? path.substring(0, path.indexOf(47)) : path;
        }
        catch (Exception e) {
            response.setStatus(400);
            throw new ServletException("Invalid path", (Throwable)e);
        }
    }
}

