/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.plugin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.plugin.framework.ContentId;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.core.ReconciliationStatus;
import com.suncode.pwfl.util.JacksonFormats;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.NonNull;

public record PluginReconciliationStatus(@NonNull PropertySyncStatus state, @NonNull PropertySyncStatus version, @NonNull PropertySyncStatus contentId, @JacksonFormats.InstantAsIso Instant updated) {
    public PluginReconciliationStatus(@NonNull PropertySyncStatus state, @NonNull PropertySyncStatus version, @NonNull PropertySyncStatus contentId, @JacksonFormats.InstantAsIso Instant updated) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (contentId == null) {
            throw new NullPointerException("contentId is marked non-null but is null");
        }
    }

    @JsonProperty
    public boolean isSynced() {
        return Stream.of(this.state, this.version, this.contentId).allMatch(PropertySyncStatus::synced);
    }

    public static PluginReconciliationStatus from(ReconciliationStatus reconciliationStatus) {
        return new PluginReconciliationStatus(PluginReconciliationStatus.from(reconciliationStatus.state(), Enum::name), PluginReconciliationStatus.from(reconciliationStatus.version(), Version::toString), PluginReconciliationStatus.from(reconciliationStatus.contentId(), ContentId::toString), reconciliationStatus.updated());
    }

    private static <T> PropertySyncStatus from(ReconciliationStatus.Property<T> property, Function<T, String> toString) {
        return new PropertySyncStatus(Optional.ofNullable(property.actual()).map(toString).orElse(""), Optional.ofNullable(property.expected()).map(toString).orElse(""), property.isSynced());
    }

    public record PropertySyncStatus(@NonNull String actual, @NonNull String expected, boolean synced) {
        public PropertySyncStatus(@NonNull String actual, @NonNull String expected, boolean synced) {
            if (actual == null) {
                throw new NullPointerException("actual is marked non-null but is null");
            }
            if (expected == null) {
                throw new NullPointerException("expected is marked non-null but is null");
            }
        }
    }
}

